/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom.geo;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.abdera.ext.geo.Box;
import org.apache.abdera.ext.geo.Coordinate;
import org.apache.abdera.ext.geo.Coordinates;
import org.apache.abdera.ext.geo.Line;
import org.apache.abdera.ext.geo.Polygon;
import org.apache.abdera.ext.geo.Position;
import org.geotools.geometry.jts.JTS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AbderaConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbderaConverter.class);

    private AbderaConverter() {
    }

    public static String convertToWKT(org.apache.abdera.ext.geo.Point point) {
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createPoint(AbderaConverter.convertCoordinateToJTS(point.getCoordinate())).toText();
    }

    public static String convertToWKT(Line line) {
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createLineString(AbderaConverter.convertCoordinatesToJTS(line.getCoordinates())).toText();
    }

    public static String convertToWKT(Polygon polygon) {
        GeometryFactory geometryFactory = new GeometryFactory();
        LinearRing ring = geometryFactory.createLinearRing(AbderaConverter.convertCoordinatesToJTS(polygon.getCoordinates()));
        return geometryFactory.createPolygon(ring, new LinearRing[0]).toText();
    }

    public static String convertToWKT(Box box) {
        com.vividsolutions.jts.geom.Coordinate coord1 = AbderaConverter.convertCoordinateToJTS(box.getLowerCorner());
        com.vividsolutions.jts.geom.Coordinate coord2 = AbderaConverter.convertCoordinateToJTS(box.getUpperCorner());
        return JTS.toGeometry((Envelope)new Envelope(coord1, coord2)).toText();
    }

    public static String convertToMultiPointWKT(Collection<Position> points) {
        GeometryFactory geometryFactory = new GeometryFactory();
        Point[] pointArray = new Point[points.size()];
        Iterator<Position> pointIterator = points.iterator();
        for (int i = 0; i < points.size(); ++i) {
            pointArray[i] = geometryFactory.createPoint(AbderaConverter.convertCoordinateToJTS(((org.apache.abdera.ext.geo.Point)pointIterator.next()).getCoordinate()));
        }
        return geometryFactory.createMultiPoint(pointArray).toText();
    }

    public static String convertToMultiLineStringWKT(Collection<Position> lines) {
        GeometryFactory geometryFactory = new GeometryFactory();
        LineString[] lineArray = new LineString[lines.size()];
        Iterator<Position> lineIterator = lines.iterator();
        for (int i = 0; i < lines.size(); ++i) {
            lineArray[i] = geometryFactory.createLineString(AbderaConverter.convertCoordinatesToJTS(((Line)lineIterator.next()).getCoordinates()));
        }
        return geometryFactory.createMultiLineString(lineArray).toText();
    }

    public static String convertToMultiPolygonWKT(Collection<Position> polygons) {
        GeometryFactory geometryFactory = new GeometryFactory();
        com.vividsolutions.jts.geom.Polygon[] polygonArray = new com.vividsolutions.jts.geom.Polygon[polygons.size()];
        Iterator<Position> polygonIterator = polygons.iterator();
        for (int i = 0; i < polygons.size(); ++i) {
            Position position = polygonIterator.next();
            if (position instanceof Box) {
                Box box = (Box)position;
                com.vividsolutions.jts.geom.Coordinate coord1 = AbderaConverter.convertCoordinateToJTS(box.getLowerCorner());
                com.vividsolutions.jts.geom.Coordinate coord2 = AbderaConverter.convertCoordinateToJTS(box.getUpperCorner());
                polygonArray[i] = JTS.toGeometry((Envelope)new Envelope(coord1, coord2));
                continue;
            }
            Polygon polygon = (Polygon)position;
            LinearRing ring = geometryFactory.createLinearRing(AbderaConverter.convertCoordinatesToJTS(polygon.getCoordinates()));
            polygonArray[i] = geometryFactory.createPolygon(ring, new LinearRing[0]);
        }
        return geometryFactory.createMultiPolygon(polygonArray).toText();
    }

    public static String convertToGeometryCollection(Collection<Position> positions) {
        GeometryFactory geometryFactory = new GeometryFactory();
        Geometry[] geometryArray = new Geometry[positions.size()];
        Iterator<Position> positionIterator = positions.iterator();
        for (int i = 0; i < positions.size(); ++i) {
            Position position = positionIterator.next();
            if (position instanceof org.apache.abdera.ext.geo.Point) {
                org.apache.abdera.ext.geo.Point point = (org.apache.abdera.ext.geo.Point)position;
                geometryArray[i] = geometryFactory.createPoint(AbderaConverter.convertCoordinateToJTS(point.getCoordinate()));
                continue;
            }
            if (position instanceof Line) {
                Line line = (Line)position;
                geometryArray[i] = geometryFactory.createLineString(AbderaConverter.convertCoordinatesToJTS(line.getCoordinates()));
                continue;
            }
            if (position instanceof Box) {
                Box box = (Box)position;
                com.vividsolutions.jts.geom.Coordinate coord1 = AbderaConverter.convertCoordinateToJTS(box.getLowerCorner());
                com.vividsolutions.jts.geom.Coordinate coord2 = AbderaConverter.convertCoordinateToJTS(box.getUpperCorner());
                geometryArray[i] = JTS.toGeometry((Envelope)new Envelope(coord1, coord2));
                continue;
            }
            Polygon polygon = (Polygon)position;
            LinearRing ring = geometryFactory.createLinearRing(AbderaConverter.convertCoordinatesToJTS(polygon.getCoordinates()));
            geometryArray[i] = geometryFactory.createPolygon(ring, new LinearRing[0]);
        }
        return geometryFactory.createGeometryCollection(geometryArray).toText();
    }

    public static String convertToWKT(Position position) {
        if (position instanceof org.apache.abdera.ext.geo.Point) {
            return AbderaConverter.convertToWKT((org.apache.abdera.ext.geo.Point)position);
        }
        if (position instanceof Line) {
            return AbderaConverter.convertToWKT((Line)position);
        }
        if (position instanceof Polygon) {
            return AbderaConverter.convertToWKT((Polygon)position);
        }
        if (position instanceof Box) {
            return AbderaConverter.convertToWKT((Box)position);
        }
        LOGGER.warn("No conversion available for the abdera geo position of type {}.", (Object)position.getClass().getName());
        return null;
    }

    public static String convertToWKT(Position[] positions) {
        boolean isPoint = false;
        boolean isLine = false;
        boolean isPolygon = false;
        int uniqueGeos = 0;
        ArrayList<Position> geos = new ArrayList<Position>();
        for (Position position : positions) {
            if (position instanceof org.apache.abdera.ext.geo.Point) {
                geos.add(position);
                if (isPoint) continue;
                ++uniqueGeos;
                isPoint = true;
                continue;
            }
            if (position instanceof Line) {
                geos.add(position);
                if (isLine) continue;
                ++uniqueGeos;
                isLine = true;
                continue;
            }
            if (position instanceof Polygon) {
                geos.add(position);
                if (isPolygon) continue;
                ++uniqueGeos;
                isPolygon = true;
                continue;
            }
            if (position instanceof Box) {
                geos.add(position);
                if (isPolygon) continue;
                ++uniqueGeos;
                isPolygon = true;
                continue;
            }
            LOGGER.warn("No conversion available for abdera geo position of type {}.", (Object)position.getClass().getName());
        }
        if (geos.isEmpty()) {
            return null;
        }
        if (geos.size() == 1) {
            return AbderaConverter.convertToWKT((Position)geos.get(0));
        }
        if (uniqueGeos > 1) {
            return AbderaConverter.convertToGeometryCollection(geos);
        }
        if (isPoint) {
            return AbderaConverter.convertToMultiPointWKT(geos);
        }
        if (isLine) {
            return AbderaConverter.convertToMultiLineStringWKT(geos);
        }
        return AbderaConverter.convertToMultiPolygonWKT(geos);
    }

    public static com.vividsolutions.jts.geom.Coordinate convertCoordinateToJTS(Coordinate coordinate) {
        return new com.vividsolutions.jts.geom.Coordinate(coordinate.getLongitude(), coordinate.getLatitude());
    }

    public static com.vividsolutions.jts.geom.Coordinate[] convertCoordinatesToJTS(Coordinates coordinates) {
        ArrayList<com.vividsolutions.jts.geom.Coordinate> jtsCoords = new ArrayList<com.vividsolutions.jts.geom.Coordinate>();
        Iterator iterator = coordinates.iterator();
        while (iterator.hasNext()) {
            jtsCoords.add(AbderaConverter.convertCoordinateToJTS((Coordinate)iterator.next()));
        }
        return jtsCoords.toArray(new com.vividsolutions.jts.geom.Coordinate[jtsCoords.size()]);
    }
}

