/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import ddf.action.Action;
import ddf.action.ActionProvider;
import ddf.catalog.data.BinaryContent;
import ddf.catalog.data.Metacard;
import ddf.catalog.data.Result;
import ddf.catalog.data.impl.BinaryContentImpl;
import ddf.catalog.operation.ProcessingDetails;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.operation.SourceResponse;
import ddf.catalog.transform.CatalogTransformerException;
import ddf.catalog.transform.MetacardTransformer;
import ddf.catalog.transform.QueryResponseTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.xml.namespace.QName;
import net.di2e.ecdr.commons.CDRMetacard;
import net.di2e.ecdr.search.transform.atom.geo.GeoHelper;
import net.di2e.ecdr.search.transform.atom.security.SecurityConfiguration;
import net.di2e.ecdr.search.transform.atom.security.SecurityData;
import net.di2e.ecdr.search.transform.atom.security.SecurityMarkingHandler;
import net.di2e.ecdr.search.transform.atom.security.impl.ConfigurationSecurityMarkingHandler;
import net.di2e.ecdr.search.transform.atom.security.impl.MetacardSecurityMarkingHandler;
import net.di2e.ecdr.search.transform.atom.security.impl.XmlMetadataSecurityMarkingHandler;
import net.di2e.ecdr.search.transform.geo.formatter.CompositeGeometry;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.geo.Position;
import org.apache.abdera.ext.opensearch.OpenSearchConstants;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.commons.lang.StringUtils;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAtomTransformer
implements MetacardTransformer,
QueryResponseTransformer {
    private static final String CDR_ATOM_TRANSFORMER_ID = "cdr-atom";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAtomTransformer.class);
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.dateTime();
    private ActionProvider viewMetacardActionProvider = null;
    private ActionProvider resourceActionProvider = null;
    private ActionProvider thumbnailActionProvider = null;
    private ActionProvider metadataActionProvider = null;
    private ConfigurationWatcherImpl configWatcher = null;
    private SecurityConfiguration securityConfiguration = null;
    private MimeType thumbnailMimeType = null;
    private MimeType viewMimeType = null;
    private boolean isTransform41 = false;
    private boolean isTransform50 = false;
    private boolean defaultToUseGMLEncoding = true;
    List<SecurityMarkingHandler> securityHandlers = null;

    public AbstractAtomTransformer(ConfigurationWatcherImpl config, ActionProvider viewMetacard, ActionProvider metadataProvider, ActionProvider resourceProvider, ActionProvider thumbnailProvider, MimeType thumbnailMime, MimeType viewMime, SecurityConfiguration securityConfig) {
        if (viewMime == null || thumbnailMime == null) {
            throw new IllegalArgumentException("MimeType parameters to constructor cannot be null");
        }
        this.configWatcher = config;
        this.viewMetacardActionProvider = viewMetacard;
        this.metadataActionProvider = metadataProvider;
        this.resourceActionProvider = resourceProvider;
        this.thumbnailActionProvider = thumbnailProvider;
        this.thumbnailMimeType = thumbnailMime;
        this.viewMimeType = viewMime;
        this.securityConfiguration = securityConfig;
        this.securityHandlers = new ArrayList<SecurityMarkingHandler>();
        this.securityHandlers.add(new MetacardSecurityMarkingHandler());
        this.securityHandlers.add(new XmlMetadataSecurityMarkingHandler());
        this.securityHandlers.add(new ConfigurationSecurityMarkingHandler(this.securityConfiguration));
    }

    public abstract void addFeedElements(Feed var1, SourceResponse var2, Map<String, Serializable> var3);

    public abstract void addEntryElements(Entry var1, CDRMetacard var2, Map<String, Serializable> var3);

    public void setUseGMLEncoding(boolean shouldUseGMLEncoding) {
        this.defaultToUseGMLEncoding = shouldUseGMLEncoding;
    }

    public void setSecurityConfiguration(SecurityConfiguration config) {
        this.securityConfiguration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryContent transform(SourceResponse response, Map<String, Serializable> properties) throws CatalogTransformerException {
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Feed feed = null;
        try {
            Thread.currentThread().setContextClassLoader(AbstractAtomTransformer.class.getClassLoader());
            feed = Abdera.getInstance().newFeed();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        feed.declareNS("urn:cdr:broker:2.0", "cdrb");
        feed.declareNS("urn:cdr-ex:search:1.1", "cdrsx");
        this.setFeedSecurity(feed);
        feed.newId();
        this.setFeedTitle(feed, properties);
        feed.setUpdated(new Date());
        List results = response.getResults();
        QueryRequest queryRequest = (QueryRequest)response.getRequest();
        feed.addExtension(OpenSearchConstants.ITEMS_PER_PAGE).setText(String.valueOf(results.size()));
        feed.addExtension(OpenSearchConstants.START_INDEX).setText(String.valueOf(queryRequest.getQuery().getStartIndex()));
        feed.addExtension(OpenSearchConstants.TOTAL_RESULTS).setText(String.valueOf(response.getHits()));
        feed.setGenerator(null, this.configWatcher.getVersion(), this.configWatcher.getSiteName());
        feed.addAuthor(this.configWatcher.getOrganization(), this.configWatcher.getContactEmailAddress(), null);
        this.addLinksToFeed(feed, properties);
        if (!this.isFalse((Boolean)properties.get("status"))) {
            this.addStatus(response, feed, results, properties);
        }
        this.addFeedElements(feed, response, properties);
        Entry entry = null;
        for (Result result : results) {
            Double distance;
            entry = this.getMetacardEntry(new CDRMetacard(result.getMetacard()), properties);
            Double relevance = result.getRelevanceScore();
            if (relevance != null) {
                Element relevanceElement = entry.addExtension(new QName("http://a9.com/-/opensearch/extensions/relevance/1.0/", "score", "relevance"));
                relevanceElement.setText(String.valueOf(relevance));
            }
            if ((distance = result.getDistanceInMeters()) != null) {
                Element distanceElement = entry.addExtension(new QName("urn:cdr-ex:search:1.1", "distance", "cdrsx"));
                distanceElement.setText(String.valueOf(distance));
            }
            feed.addEntry(entry);
        }
        BinaryContentImpl binaryContent = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(AbstractAtomTransformer.class.getClassLoader());
                feed.writeTo((OutputStream)outputStream);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            binaryContent = new BinaryContentImpl((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), new MimeType("application/atom+xml"));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (MimeTypeParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return binaryContent;
    }

    protected void addStatus(SourceResponse response, Feed feed, List<Result> results, Map<String, Serializable> properties) {
        if (response instanceof QueryResponse) {
            QueryResponse queryResponse = (QueryResponse)response;
            Set details = queryResponse.getProcessingDetails();
            ArrayList siteList = (ArrayList)queryResponse.getPropertyValue("site-list");
            if (siteList == null) {
                siteList = new ArrayList();
            }
            for (ProcessingDetails detail : details) {
                String sourceId = detail.getSourceId();
                siteList.remove(sourceId);
                ExtensibleElement sourceStatus = (ExtensibleElement)feed.addExtension("urn:cdr:broker:2.0", "sourceStatus", "cdrb");
                sourceStatus.setAttributeValue(new QName("urn:cdr:broker:2.0", "sourceId", "cdrb"), sourceId);
                sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "shortName", "cdrb", sourceId);
                String feedPath = (String)((Object)properties.get("path"));
                if (detail.hasException()) {
                    sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "status", "cdrb", "error");
                    sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "resultsRetrieved", "cdrb", "0");
                    if (StringUtils.isNotBlank((String)feedPath)) {
                        sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "path", "cdrb", feedPath);
                    }
                    sourceStatus.addSimpleExtension("urn:cdr-ex:search:1.1", "warning", "cdrsx", detail.getException().getMessage());
                    sourceStatus.addSimpleExtension("urn:cdr-ex:search:1.1", "statusMessage", "cdrsx", "Search complete with errors");
                    continue;
                }
                Serializable object = queryResponse.getPropertyValue(sourceId);
                if (object != null && object instanceof Map) {
                    Integer totalResultsReturned;
                    Long totalHits;
                    Map sourceProperties = (Map)((Object)object);
                    Long elapsedTime = (Long)sourceProperties.get("elapsed-time");
                    if (elapsedTime != null) {
                        sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "elapsedTime", "cdrb", String.valueOf(elapsedTime));
                    }
                    if ((totalHits = (Long)sourceProperties.get("total-hits")) != null) {
                        sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "totalResults", "cdrb", String.valueOf(totalHits));
                    }
                    if ((totalResultsReturned = (Integer)sourceProperties.get("total-results-returned")) != null) {
                        sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "resultsRetrieved", "cdrb", String.valueOf(totalResultsReturned));
                    }
                } else {
                    sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "resultsRetrieved", "cdrb", String.valueOf(results.size()));
                }
                sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "status", "cdrb", "complete");
                if (StringUtils.isNotBlank((String)feedPath)) {
                    sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "path", "cdrb", feedPath);
                }
                sourceStatus.addSimpleExtension("urn:cdr-ex:search:1.1", "statusMessage", "cdrsx", "Search complete with no errors");
                List warnings = detail.getWarnings();
                if (warnings == null || warnings.isEmpty()) continue;
                sourceStatus.addSimpleExtension("urn:cdr-ex:search:1.1", "warning", "cdrsx", (String)warnings.get(0));
            }
            if (details.isEmpty() && siteList.isEmpty()) {
                String sourceId = (String)((Object)properties.get("local-source-id"));
                if (sourceId == null) {
                    sourceId = "SELF";
                }
                ExtensibleElement sourceStatus = (ExtensibleElement)feed.addExtension("urn:cdr:broker:2.0", "sourceStatus", "cdrb");
                sourceStatus.setAttributeValue(new QName("urn:cdr:broker:2.0", "sourceId", "cdrb"), sourceId);
                sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "shortName", "cdrb", sourceId);
                sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "status", "cdrb", "complete");
                sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "resultsRetrieved", "cdrb", String.valueOf(results.size()));
                sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "totalResults", "cdrb", String.valueOf(response.getHits()));
                sourceStatus.addSimpleExtension("urn:cdr-ex:search:1.1", "statusMessage", "cdrsx", "Search complete with no errors");
            } else if (!siteList.isEmpty()) {
                for (String site : siteList) {
                    ExtensibleElement sourceStatus = (ExtensibleElement)feed.addExtension("urn:cdr:broker:2.0", "sourceStatus", "cdrb");
                    sourceStatus.setAttributeValue(new QName("urn:cdr:broker:2.0", "sourceId", "cdrb"), site);
                    sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "shortName", "cdrb", site);
                    String feedPath = (String)((Object)properties.get("path"));
                    Serializable object = queryResponse.getPropertyValue(site);
                    if (object != null && object instanceof Map) {
                        Integer totalResultsReturned;
                        Long totalHits;
                        Map sourceProperties = (Map)((Object)object);
                        Long elapsedTime = (Long)sourceProperties.get("elapsed-time");
                        if (elapsedTime != null) {
                            sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "elapsedTime", "cdrb", String.valueOf(elapsedTime));
                        }
                        if ((totalHits = (Long)sourceProperties.get("total-hits")) != null) {
                            sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "totalResults", "cdrb", String.valueOf(totalHits));
                        }
                        if ((totalResultsReturned = (Integer)sourceProperties.get("total-results-returned")) != null) {
                            sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "resultsRetrieved", "cdrb", String.valueOf(totalResultsReturned));
                        }
                        sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "status", "cdrb", "complete");
                        sourceStatus.addSimpleExtension("urn:cdr-ex:search:1.1", "statusMessage", "cdrsx", "Search complete with no errors");
                    } else {
                        sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "resultsRetrieved", "cdrb", "0");
                        sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "status", "cdrb", "waiting");
                        sourceStatus.addSimpleExtension("urn:cdr-ex:search:1.1", "statusMessage", "cdrsx", "Source is still being searched, and has not returned results yet");
                    }
                    if (!StringUtils.isNotBlank((String)feedPath)) continue;
                    sourceStatus.addSimpleExtension("urn:cdr:broker:2.0", "path", "cdrb", feedPath);
                }
            }
        }
    }

    protected boolean isFalse(Boolean includeStatus) {
        return Boolean.FALSE.equals(includeStatus);
    }

    public BinaryContent transform(Metacard metacard, Map<String, Serializable> properties) throws CatalogTransformerException {
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        Entry entry = this.getMetacardEntry(new CDRMetacard(metacard), properties);
        BinaryContentImpl binaryContent = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            entry.writeTo((OutputStream)outputStream);
            binaryContent = new BinaryContentImpl((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), new MimeType("application/atom+xml"));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (MimeTypeParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return binaryContent;
    }

    protected ActionProvider getViewMetacardActionProvider() {
        return this.viewMetacardActionProvider;
    }

    protected ActionProvider getThumbnailActionProvider() {
        return this.thumbnailActionProvider;
    }

    protected ActionProvider getResourceActionProvider() {
        return this.resourceActionProvider;
    }

    protected ConfigurationWatcherImpl getConfigurationWatcherImpl() {
        return this.configWatcher;
    }

    protected MimeType getThumbnailMimeType() {
        return this.thumbnailMimeType;
    }

    protected MimeType getViewMimeType() {
        return this.viewMimeType;
    }

    protected boolean isTransform41() {
        return this.isTransform41;
    }

    protected boolean isTransform50() {
        return this.isTransform50;
    }

    protected Entry getMetacardEntry(CDRMetacard metacard, Map<String, Serializable> properties) {
        Date expirationDate;
        Date createdDate;
        String format = (String)((Object)properties.get("format"));
        Entry entry = Abdera.getInstance().newEntry();
        entry.declareNS("http://www.georss.org/georss", "georss");
        entry.declareNS("http://a9.com/-/opensearch/extensions/relevance/1.0/", "relevance");
        this.setEntrySecurity(entry, (Metacard)metacard);
        entry.setId(metacard.getAtomId());
        entry.setTitle(metacard.getTitle());
        entry.setUpdated(metacard.getModifiedDate());
        Date effective = metacard.getEffectiveDate();
        if (effective != null) {
            entry.setPublished(effective);
        }
        entry.addCategory(metacard.getContentTypeVersion(), metacard.getContentTypeName(), "Content Type");
        String sourceId = metacard.getSourceId();
        if (sourceId != null) {
            ExtensibleElement element = (ExtensibleElement)entry.addExtension("urn:cdr:broker:2.0", "resultSource", "cdrb");
            element.setAttributeValue(new QName("urn:cdr:broker:2.0", "sourceId", "cdrb"), sourceId);
            element.setText(sourceId);
        }
        this.addLinksToEntry(entry, metacard, format);
        if (metacard.hasLocation()) {
            this.addLocation(entry, (Metacard)metacard, this.useGmlEncoding(properties));
        }
        if ((createdDate = metacard.getCreatedDate()) != null) {
            entry.addSimpleExtension("urn:catalog:metacard:atom", "createdDate", "metacard", DATE_FORMATTER.print(createdDate.getTime()));
        }
        if ((expirationDate = metacard.getExpirationDate()) != null) {
            entry.addSimpleExtension("urn:catalog:metacard:atom", "expirationDate", "metacard", DATE_FORMATTER.print(expirationDate.getTime()));
        }
        this.addEntryElements(entry, metacard, properties);
        return entry;
    }

    protected boolean useGmlEncoding(Map<String, Serializable> properties) {
        String format = (String)((Object)properties.get("georssFormat"));
        boolean useGml = this.defaultToUseGMLEncoding;
        if (StringUtils.isNotBlank((String)format)) {
            if ("simple".equalsIgnoreCase(format)) {
                useGml = false;
            } else if ("gml".equalsIgnoreCase(format)) {
                useGml = true;
            }
        }
        return useGml;
    }

    protected void addLinksToEntry(Entry entry, CDRMetacard metacard, String format) {
        Action action;
        if (metacard.hasThumbnail()) {
            Action action2;
            URI thumbnailURI = metacard.getThumbnailURL();
            if (this.thumbnailActionProvider != null && (action2 = this.thumbnailActionProvider.getAction((Object)metacard)) != null && action2.getUrl() != null) {
                entry.addLink(action2.getUrl().toString(), "preview", this.thumbnailMimeType.getBaseType(), action2.getTitle(), null, metacard.getThumbnailLength());
            }
        }
        if (this.resourceActionProvider != null && metacard.hasResource()) {
            action = this.resourceActionProvider.getAction((Object)metacard);
            if (action != null && action.getUrl() != null) {
                entry.addLink(action.getUrl().toString(), "alternate", metacard.getResourceMIMETypeString(), action.getTitle(), null, metacard.getResourceSizeLong());
            }
        } else if (this.metadataActionProvider != null && (action = this.metadataActionProvider.getAction((Object)metacard)) != null && action.getUrl() != null) {
            entry.addLink(action.getUrl().toString(), "alternate", "text/xml", "View Product", null, -1L);
        }
        if (this.viewMetacardActionProvider != null && (action = this.viewMetacardActionProvider.getAction((Object)metacard)) != null && action.getUrl() != null) {
            entry.addLink(action.getUrl().toString() + "?transform=" + (format == null ? CDR_ATOM_TRANSFORMER_ID : format), "self", "application/atom+xml", "View Atom Entry", null, -1L);
            entry.addLink(action.getUrl().toString(), "related", "text/xml", action.getTitle(), null, -1L);
        }
    }

    protected void addLocation(Entry entry, Metacard metacard, boolean useGmlEncoding) {
        WKTReader reader = new WKTReader();
        try {
            Geometry geo = reader.read(metacard.getLocation());
            List<Position> positions = CompositeGeometry.getCompositeGeometry(geo).toGeoRssPositions();
            for (Position position : positions) {
                if (useGmlEncoding) {
                    GeoHelper.addPosition((ExtensibleElement)entry, position, GeoHelper.Encoding.GML);
                    continue;
                }
                GeoHelper.addPosition((ExtensibleElement)entry, position, GeoHelper.Encoding.SIMPLE);
            }
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void addLinksToFeed(Feed feed, Map<String, Serializable> properties) {
        Serializable property = properties.get("self");
        if (property != null && property instanceof String) {
            feed.addLink(String.valueOf(property), "self", "application/atom+xml", "Current Page", null, -1L);
        }
        if ((property = properties.get("first")) != null && property instanceof String) {
            feed.addLink(String.valueOf(property), "first", "application/atom+xml", "First Page", null, -1L);
        }
        if ((property = properties.get("last")) != null && property instanceof String) {
            feed.addLink(String.valueOf(property), "last", "application/atom+xml", "Last Page", null, -1L);
        }
        if ((property = properties.get("next")) != null && property instanceof String) {
            feed.addLink(String.valueOf(property), "next", "application/atom+xml", "Next Page", null, -1L);
        }
        if ((property = properties.get("previous")) != null && property instanceof String) {
            feed.addLink(String.valueOf(property), "previous", "application/atom+xml", "Previous Page", null, -1L);
        }
    }

    protected void setFeedTitle(Feed feed, Map<String, Serializable> properties) {
        Serializable property = properties.get("feed-title");
        if (property != null && property instanceof String) {
            feed.setTitle(String.valueOf(property));
        } else {
            feed.setTitle("Atom Search Results Feed from source:" + this.configWatcher.getSiteName());
        }
    }

    protected void setFeedSecurity(Feed feed) {
        Map<String, String> securityAttributes;
        String namespace;
        if (this.securityConfiguration != null && StringUtils.isNotBlank((String)(namespace = this.securityConfiguration.getResultSecurityNamespace())) && (securityAttributes = this.securityConfiguration.getResultSecurityMarkings()) != null && !securityAttributes.isEmpty()) {
            feed.declareNS(namespace, "ism");
            for (Map.Entry<String, String> securityEntry : securityAttributes.entrySet()) {
                String securityValue = securityEntry.getValue();
                if (!StringUtils.isNotBlank((String)securityValue)) continue;
                feed.setAttributeValue(new QName(namespace, securityEntry.getKey()), securityEntry.getValue());
            }
        }
    }

    protected void setEntrySecurity(Entry entry, Metacard metacard) {
        for (SecurityMarkingHandler securityHandler : this.securityHandlers) {
            String securityNamespace;
            SecurityData securityData = securityHandler.getSecurityData(metacard);
            if (securityData == null || !StringUtils.isNotBlank((String)(securityNamespace = securityData.getSecurityNamespace()))) continue;
            boolean hasAttribute = false;
            for (Map.Entry<String, List<String>> securityEntry : securityData.getSecurityMarkings().entrySet()) {
                List<String> securityValues = securityEntry.getValue();
                if (securityValues == null || securityValues.isEmpty()) continue;
                if (!hasAttribute) {
                    entry.declareNS(securityNamespace, "ism");
                }
                entry.setAttributeValue(new QName(securityNamespace, securityEntry.getKey()), StringUtils.join(securityValues, (String)" "));
                hasAttribute = true;
            }
            if (!hasAttribute) continue;
            break;
        }
    }
}

