/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom.response;

import ddf.catalog.data.Metacard;
import ddf.catalog.data.Result;
import ddf.catalog.data.impl.MetacardImpl;
import ddf.catalog.data.impl.ResultImpl;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.SourceResponse;
import ddf.catalog.operation.impl.SourceResponseImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.xml.namespace.QName;
import net.di2e.ecdr.commons.CDRMetacard;
import net.di2e.ecdr.commons.filter.config.FilterConfig;
import net.di2e.ecdr.commons.response.SearchResponseTransformer;
import net.di2e.ecdr.search.transform.atom.geo.AbderaConverter;
import net.di2e.ecdr.search.transform.atom.geo.GeoHelper;
import net.di2e.ecdr.search.transform.atom.response.security.SecurityMarkingParser;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.geo.Position;
import org.apache.abdera.ext.opensearch.OpenSearchConstants;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.parser.Parser;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomResponseTransformer
implements SearchResponseTransformer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(AtomResponseTransformer.class);
    private static final String METADATA_ELEMENT_NAME = "Resource";
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.dateTimeParser();
    private static final Abdera ABDERA = Abdera.getInstance();
    private FilterConfig filterConfig = null;

    public AtomResponseTransformer(FilterConfig config) {
        this.filterConfig = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceResponse processSearchResponse(InputStream inputStream, QueryRequest request, String siteName) {
        Document atomDoc;
        ArrayList<Result> resultList = new ArrayList<Result>();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Parser parser = null;
        try {
            Thread.currentThread().setContextClassLoader(AtomResponseTransformer.class.getClassLoader());
            parser = ABDERA.getParser();
            atomDoc = parser.parse((Reader)new InputStreamReader(inputStream));
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        Feed feed = (Feed)atomDoc.getRoot();
        List entries = feed.getEntries();
        int size = entries.size();
        for (Entry entry : entries) {
            if (this.isValidEntry(entry)) {
                Metacard metacard = this.entryToMetacard(entry, siteName);
                resultList.add(this.metacardToResult(entry, metacard));
                continue;
            }
            LOGGER.debug("Skipping invalid entry: {}", (Object)entry);
            --size;
        }
        long totalResults = size;
        Element totalResultsElement = ((Feed)atomDoc.getRoot()).getExtension(OpenSearchConstants.TOTAL_RESULTS);
        if (totalResultsElement != null) {
            try {
                totalResults = Long.parseLong(totalResultsElement.getText());
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Received invalid number of results from Atom response [" + totalResultsElement.getText() + "]", (Throwable)e);
            }
        }
        Map responseProperties = null;
        return new SourceResponseImpl(request, responseProperties, resultList, totalResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Metacard entryToMetacard(Entry entry, String siteName) {
        String metadataLinkRel;
        List links;
        String thumbnailLinkRel;
        String expirationDate;
        MetacardImpl metacard = new MetacardImpl();
        String id = entry.getIdElement().getText();
        if (StringUtils.isNotBlank((String)id) && (id.startsWith("urn:uuid:") || id.startsWith("urn:catalog:id:"))) {
            id = id.substring(id.lastIndexOf(58) + 1);
        }
        metacard.setId(id);
        metacard.setSourceId(siteName);
        List categories = entry.getCategories();
        if (categories != null && !categories.isEmpty()) {
            Category category = (Category)categories.get(0);
            metacard.setContentTypeName(category.getTerm());
            IRI scheme = category.getScheme();
            if (scheme != null) {
                metacard.setContentTypeVersion(scheme.toString());
            }
        }
        metacard.setModifiedDate(entry.getUpdated());
        metacard.setEffectiveDate(entry.getPublished());
        String createdDate = entry.getSimpleExtension(new QName("urn:catalog:metacard:atom", "createdDate"));
        if (createdDate != null) {
            metacard.setCreatedDate(new Date(DATE_FORMATTER.parseMillis(createdDate)));
        }
        if ((expirationDate = entry.getSimpleExtension(new QName("urn:catalog:metacard:atom", "expirationDate"))) != null) {
            metacard.setExpirationDate(new Date(DATE_FORMATTER.parseMillis(expirationDate)));
        }
        FilterConfig.AtomContentXmlWrapOption wrap = this.filterConfig.getAtomContentXmlWrapOption();
        String metadata = entry.getContent();
        if (metadata != null) {
            if (wrap != null && !wrap.equals((Object)FilterConfig.AtomContentXmlWrapOption.NEVER_WRAP)) {
                if (wrap.equals((Object)FilterConfig.AtomContentXmlWrapOption.WRAP_HTML_AND_TEXT)) {
                    Content.Type contentType = entry.getContentType();
                    switch (contentType) {
                        case TEXT: 
                        case HTML: {
                            metadata = "<xml-fragment>" + metadata + "</xml-fragment>";
                            break;
                        }
                    }
                } else {
                    metadata = "<xml-fragment>" + metadata + "</xml-fragment>";
                }
            }
            metacard.setMetadata(metadata);
        }
        metacard.setLocation(this.getWKT(entry));
        Link productLink = entry.getLink(this.filterConfig.getProductLinkRelation());
        if (productLink != null) {
            MimeType productType;
            String productTitle;
            metacard.setResourceURI(URI.create(productLink.getHref().toASCIIString()));
            long resourceSize = productLink.getLength();
            if (resourceSize > 0L) {
                metacard.setResourceSize(String.valueOf(resourceSize));
            }
            if ((productTitle = productLink.getTitle()) != null) {
                metacard.setAttribute("resource-title", (Serializable)((Object)productTitle));
            }
            if ((productType = productLink.getMimeType()) != null) {
                metacard.setAttribute("resource-mime-type", (Serializable)((Object)productType.toString()));
            }
        }
        if ((thumbnailLinkRel = this.filterConfig.getThumbnailLinkRelation()) != null && (links = entry.getLinks(thumbnailLinkRel)) != null && !links.isEmpty()) {
            for (Link link : links) {
                MimeType mimeType = link.getMimeType();
                if (mimeType != null && !"image".equals(mimeType.getPrimaryType())) continue;
                metacard.setAttribute("thumbnail-link", (Serializable)URI.create(link.getHref().toASCIIString()));
                long thumbnailSize = link.getLength();
                if (thumbnailSize > 0L) {
                    metacard.setAttribute("thumbnail-length", (Serializable)Long.valueOf(thumbnailSize));
                }
                metacard.setAttribute("thumbnail-mimetype", (Serializable)link.getMimeType());
                metacard.setAttribute("thumbnail-link-title", (Serializable)((Object)link.getTitle()));
            }
        }
        metacard.setTitle(entry.getTitle());
        boolean isMetadataSet = false;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AtomResponseTransformer.class.getClassLoader());
            List extensions = entry.getExtensions();
            for (Element element : extensions) {
                if (!METADATA_ELEMENT_NAME.equalsIgnoreCase(element.getQName().getLocalPart())) continue;
                StringWriter writer = new StringWriter();
                try {
                    element.writeTo((Writer)writer);
                    metacard.setMetadata(writer.toString());
                    isMetadataSet = true;
                    break;
                }
                catch (IOException e) {
                    LOGGER.error("Could not convert Metadata String value from Atom to Metacard.METADATA attribute", (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        if (!isMetadataSet && (metadataLinkRel = this.filterConfig.getMetadataLinkRelation()) != null) {
            List metadataLinks = entry.getLinks(metadataLinkRel);
            String metadataLink = null;
            for (Link link : metadataLinks) {
                MimeType mimeType = link.getMimeType();
                if (mimeType == null || !mimeType.getSubType().contains("xml")) continue;
                metadataLink = link.getHref().toASCIIString();
                metacard.setAttribute("metadata-link", (Serializable)URI.create(metadataLink));
            }
        }
        Metacard returnMetacard = SecurityMarkingParser.addSecurityToMetacard((Metacard)metacard, entry);
        return new CDRMetacard(returnMetacard);
    }

    protected Result metacardToResult(Entry entry, Metacard metacard) {
        String distance;
        ResultImpl result = new ResultImpl(metacard);
        String relevance = entry.getSimpleExtension("http://a9.com/-/opensearch/extensions/relevance/1.0/", "score", "relevance");
        if (relevance != null) {
            try {
                result.setRelevanceScore(Double.valueOf(Double.parseDouble(relevance)));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Received invalid number for relevance from Atom response [" + relevance + "]", (Throwable)e);
            }
        }
        if ((distance = entry.getSimpleExtension("urn:cdr-ex:search:1.1", "distance", "cdrsx")) != null) {
            try {
                result.setDistanceInMeters(Double.valueOf(Double.parseDouble(distance)));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Received invalid number for distance from Atom response [" + distance + "]", (Throwable)e);
            }
        }
        return result;
    }

    protected String getWKT(Entry entry) {
        String wkt = null;
        Position[] positions = GeoHelper.getPositions((ExtensibleElement)entry);
        int length = positions.length;
        if (length == 1) {
            LOGGER.debug("Found one geometry in the current Atom entry, converting to WKT for inclusion in metacard");
            return AbderaConverter.convertToWKT(positions[0]);
        }
        if (length > 1) {
            LOGGER.debug("Found multiple geometries in the current Atom entry, converting to MULTI-WKT for inclusion in metacard");
            return AbderaConverter.convertToWKT(positions);
        }
        return wkt;
    }

    private boolean isValidEntry(Entry entry) {
        if (entry == null) {
            return false;
        }
        return entry.getIdElement() != null && entry.getTitleElement() != null && entry.getUpdatedElement() != null;
    }
}

