/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.geo.formatter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.search.transform.geo.formatter.CompositeGeometry;
import net.di2e.ecdr.search.transform.geo.formatter.LineString;
import org.apache.abdera.ext.geo.Line;
import org.apache.abdera.ext.geo.Position;

public class MultiLineString
extends LineString {
    public static final String TYPE = "MultiLineString";

    public MultiLineString(Geometry geometry) {
        super(geometry);
    }

    public static CompositeGeometry toCompositeGeometry(List coordinates) {
        com.vividsolutions.jts.geom.LineString[] allLineStrings = new com.vividsolutions.jts.geom.LineString[coordinates.size()];
        for (int i = 0; i < allLineStrings.length; ++i) {
            allLineStrings[i] = GEOMETRY_FACTORY.createLineString(MultiLineString.getCoordinates((List)coordinates.get(i)));
        }
        return new MultiLineString((Geometry)GEOMETRY_FACTORY.createMultiLineString(allLineStrings));
    }

    @Override
    public Map toJsonMap() {
        ArrayList<List<List<Double>>> overallCoordsList = new ArrayList<List<List<Double>>>();
        for (int i = 0; i < this.getGeometry().getNumGeometries(); ++i) {
            overallCoordsList.add(this.buildCoordinatesList(this.getGeometry().getGeometryN(i).getCoordinates()));
        }
        return this.createMap("coordinates", overallCoordsList);
    }

    @Override
    public List<Position> toGeoRssPositions() {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (int i = 0; i < this.getGeometry().getNumGeometries(); ++i) {
            positions.add((Position)new Line(this.getLineStringCoordinates(this.getGeometry().getGeometryN(i))));
        }
        return positions;
    }
}

