/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.geo.formatter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.search.transform.geo.formatter.CompositeGeometry;
import net.di2e.ecdr.search.transform.geo.formatter.MultiPoint;
import org.apache.abdera.ext.geo.Coordinates;
import org.apache.abdera.ext.geo.Line;
import org.apache.abdera.ext.geo.Position;

public class LineString
extends MultiPoint {
    public static final String TYPE = "LineString";

    public LineString(Geometry geometry) {
        super(geometry);
    }

    public static CompositeGeometry toCompositeGeometry(List coordinates) {
        return new LineString((Geometry)GEOMETRY_FACTORY.createLineString(LineString.getCoordinates(coordinates)));
    }

    @Override
    public Map toJsonMap() {
        return this.createMap("coordinates", this.buildCoordinatesList(this.getGeometry().getCoordinates()));
    }

    @Override
    public List<Position> toGeoRssPositions() {
        Coordinates coordinates = this.getLineStringCoordinates(this.getGeometry());
        return Arrays.asList(new Line(coordinates));
    }

    protected Coordinates getLineStringCoordinates(Geometry geometry) {
        Coordinates coordinates = new Coordinates();
        for (int i = 0; i < geometry.getCoordinates().length; ++i) {
            Coordinate coordinate = geometry.getCoordinates()[i];
            coordinates.add(this.convert(coordinate));
        }
        return coordinates;
    }
}

