/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom.response;

import ddf.catalog.data.Metacard;
import ddf.catalog.data.Result;
import ddf.catalog.data.impl.MetacardImpl;
import ddf.catalog.data.impl.ResultImpl;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.SourceResponse;
import ddf.catalog.operation.impl.SourceResponseImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.MimeType;
import javax.xml.namespace.QName;
import net.di2e.ecdr.commons.response.SearchResponseTransformer;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.geo.Coordinate;
import org.apache.abdera.ext.geo.GeoHelper;
import org.apache.abdera.ext.geo.Point;
import org.apache.abdera.ext.geo.Position;
import org.apache.abdera.ext.opensearch.OpenSearchConstants;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.parser.Parser;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomResponseTransformer
implements SearchResponseTransformer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(AtomResponseTransformer.class);
    private static final String METADATA_ELEMENT_NAME = "Resource";
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.dateTimeParser();
    private static final Abdera ABDERA = Abdera.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceResponse processSearchResponse(InputStream inputStream, String format, QueryRequest request, String siteName) {
        Document atomDoc;
        ArrayList<Result> resultList = new ArrayList<Result>();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Parser parser = null;
        try {
            Thread.currentThread().setContextClassLoader(AtomResponseTransformer.class.getClassLoader());
            parser = ABDERA.getParser();
            atomDoc = parser.parse((Reader)new InputStreamReader(inputStream));
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        Feed feed = (Feed)atomDoc.getRoot();
        List entries = feed.getEntries();
        for (Entry entry : entries) {
            resultList.add(this.createResponseFromEntry(entry, siteName));
        }
        long totalResults = entries.size();
        Element totalResultsElement = ((Feed)atomDoc.getRoot()).getExtension(OpenSearchConstants.TOTAL_RESULTS);
        if (totalResultsElement != null) {
            try {
                totalResults = Long.parseLong(totalResultsElement.getText());
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Received invalid number of results from Atom response [" + totalResultsElement.getText() + "]", (Throwable)e);
            }
        }
        return new SourceResponseImpl(request, resultList, Long.valueOf(totalResults));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result createResponseFromEntry(Entry entry, String siteName) {
        String distance;
        List links;
        String expirationDate;
        MetacardImpl metacard = new MetacardImpl();
        String id = entry.getIdElement().getText();
        if (id != null && id.contains(":")) {
            id = id.substring(id.lastIndexOf(58) + 1);
        }
        metacard.setId(id);
        String resultSource = entry.getSimpleExtension("urn:cdr:broker:2.0", "resultSource", "cdrb");
        metacard.setSourceId(resultSource == null ? siteName : resultSource);
        List categories = entry.getCategories();
        if (categories != null && !categories.isEmpty()) {
            Category category = (Category)categories.get(0);
            metacard.setContentTypeName(category.getTerm());
            metacard.setContentTypeVersion(category.getScheme().toString());
        }
        metacard.setModifiedDate(entry.getUpdated());
        metacard.setEffectiveDate(entry.getPublished());
        String createdDate = entry.getSimpleExtension(new QName("urn:catalog:metacard:atom", "createdDate"));
        if (createdDate != null) {
            metacard.setCreatedDate(new Date(DATE_FORMATTER.parseMillis(createdDate)));
        }
        if ((expirationDate = entry.getSimpleExtension(new QName("urn:catalog:metacard:atom", "expirationDate"))) != null) {
            metacard.setExpirationDate(new Date(DATE_FORMATTER.parseMillis(expirationDate)));
        }
        String metadata = entry.getContent();
        metacard.setMetadata(metadata);
        metacard.setLocation(this.getWKT(entry));
        Link productLink = entry.getAlternateLink();
        if (productLink != null) {
            MimeType productType;
            String productTitle;
            metacard.setResourceURI(URI.create(productLink.getHref().toASCIIString()));
            long resourceSize = productLink.getLength();
            if (resourceSize > 0L) {
                metacard.setResourceSize(String.valueOf(resourceSize));
            }
            if ((productTitle = productLink.getTitle()) != null) {
                metacard.setAttribute("resource-title", (Serializable)((Object)productTitle));
            }
            if ((productType = productLink.getMimeType()) != null) {
                metacard.setAttribute("resource-mime-type", (Serializable)((Object)productType.toString()));
            }
        }
        if ((links = entry.getLinks("preview")) != null && !links.isEmpty()) {
            for (Link link : links) {
                MimeType mimeType = link.getMimeType();
                if (mimeType == null || !"image".equals(mimeType.getPrimaryType())) continue;
                metacard.setAttribute("thumbnail-link", (Serializable)URI.create(link.getHref().toASCIIString()));
                long thumbnailSize = link.getLength();
                if (thumbnailSize > 0L) {
                    metacard.setAttribute("thumbnail-length", (Serializable)Long.valueOf(thumbnailSize));
                }
                metacard.setAttribute("thumbnail-mimetype", (Serializable)link.getMimeType());
                metacard.setAttribute("thumbnail-link-title", (Serializable)((Object)link.getTitle()));
            }
        }
        metacard.setTitle(entry.getTitle());
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AtomResponseTransformer.class.getClassLoader());
            List extensions = entry.getExtensions();
            for (Element element : extensions) {
                if (!METADATA_ELEMENT_NAME.equalsIgnoreCase(element.getQName().getLocalPart())) continue;
                StringWriter writer = new StringWriter();
                try {
                    element.writeTo((Writer)writer);
                    metacard.setMetadata(writer.toString());
                }
                catch (IOException e) {
                    LOGGER.error("Could not convert Metadata String value from Atom to Metacard.METADATA attribute", (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        ResultImpl result = new ResultImpl((Metacard)metacard);
        String relevance = entry.getSimpleExtension("http://a9.com/-/opensearch/extensions/relevance/1.0/", "score", "relevance");
        if (relevance != null) {
            try {
                result.setRelevanceScore(Double.valueOf(Double.parseDouble(relevance)));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Received invalid number for relevance from Atom response [" + relevance + "]", (Throwable)e);
            }
        }
        if ((distance = entry.getSimpleExtension("urn:cdr-ex:search:1.1", "distance", "cdrsx")) != null) {
            try {
                result.setDistanceInMeters(Double.valueOf(Double.parseDouble(relevance)));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Received invalid number for distance from Atom response [" + distance + "]", (Throwable)e);
            }
        }
        return result;
    }

    private String getWKT(Entry entry) {
        String wkt = null;
        ExtensibleElement geoElement = (ExtensibleElement)entry.getExtension(GeoHelper.QNAME_SIMPLE_POINT);
        if (geoElement != null) {
            Position position = GeoHelper.getAsPosition((Element)geoElement);
            if (position instanceof Point) {
                Coordinate coord = ((Point)position).getCoordinate();
                wkt = "POINT(" + coord.getLongitude() + " " + coord.getLatitude() + ")";
            }
        } else {
            geoElement = (ExtensibleElement)entry.getExtension(GeoHelper.QNAME_WHERE);
        }
        return wkt;
    }
}

