/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.querylanguage.cql;

import ddf.catalog.filter.FilterBuilder;
import ddf.catalog.source.UnsupportedQueryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import net.di2e.ecdr.api.config.SortTypeConfiguration;
import net.di2e.ecdr.api.query.QueryConfiguration;
import net.di2e.ecdr.api.query.QueryCriteria;
import net.di2e.ecdr.api.query.QueryLanguage;
import net.di2e.ecdr.commons.query.CDRQueryCriteriaImpl;
import net.di2e.ecdr.commons.util.SearchUtils;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLQueryLanguage
implements QueryLanguage {
    private static final Logger LOGGER = LoggerFactory.getLogger(CQLQueryLanguage.class);
    private FilterBuilder filterBuilder = null;
    private List<SortTypeConfiguration> sortTypeConfigurationList = null;

    public CQLQueryLanguage(FilterBuilder builder, List<SortTypeConfiguration> sortTypeConfigurations) {
        this.filterBuilder = builder;
        this.sortTypeConfigurationList = sortTypeConfigurations;
    }

    public String getUrlTemplateParameters() {
        return "&sortKeys={sru:sortKeys?}";
    }

    public String getName() {
        return "cql-1.2";
    }

    public String getLanguageDescription(QueryConfiguration queryConfig) {
        return "CQL Query Language\n****************************" + System.lineSeparator() + "Usage: To use the CQL query language specify '" + this.getName() + "' in the {cdrs:queryLanguage} parameter placeholder." + System.lineSeparator() + "       The CQL query string should be put the contents of the CQL query in the {os:searchTerms} parameter placeholder." + System.lineSeparator() + System.lineSeparator() + "Examples:  metadata like 'test'" + System.lineSeparator() + "           created <> '2014-01-03'" + System.lineSeparator() + "           metadata = 'England' and (title = 'London' and created before 2014-05-05T00:00:00) or (title = 'Cambridge' and created between '2014-01-03' and '2014-03-03')" + System.lineSeparator() + System.lineSeparator() + "**** Sort Order ****" + System.lineSeparator() + System.lineSeparator() + "sru:sortKeys - space-separated list of sort keys, with individual sort keys comprised of a comma-separated " + "sequence of sub-parameters in the order listed below." + System.lineSeparator() + "    path - Mandatory. An XPath expression for a tagpath to be used in the sort (wildcards '*' may be supported, see allowed values)" + System.lineSeparator() + "    sortSchema - Optional. A short name for a URI identifying an XML schema to which the XPath expression applies" + System.lineSeparator() + "    ascending - Optional. Boolean, default 'true'." + System.lineSeparator() + "    caseSensitive - Optional. Boolean, default 'false'." + System.lineSeparator() + "    missingValue - Optional. Default is 'highValue'." + System.lineSeparator() + "            examples: Sort by relevance - score" + System.lineSeparator() + "                      Sort by updated time descending - date,,false " + System.lineSeparator() + "                      Sort by distance - distance" + System.lineSeparator() + "            'path' allowedValues: " + SearchUtils.getAllowedSortValues(this.sortTypeConfigurationList) + System.lineSeparator();
    }

    public boolean isValidQuery(MultivaluedMap<String, String> queryParameters) {
        return true;
    }

    public QueryCriteria getQueryCriteria(MultivaluedMap<String, String> queryParameters, QueryConfiguration queryConfig) throws UnsupportedQueryException {
        LOGGER.debug("Parsing query using the CDRKeywordQueryLanguage");
        ArrayList filters = new ArrayList();
        SortBy sortBy = SearchUtils.getSortBy((String)((String)queryParameters.getFirst((Object)"sortKeys")), this.sortTypeConfigurationList, (boolean)true);
        SearchUtils.logSort((SortBy)sortBy);
        String cqlStr = (String)queryParameters.getFirst((Object)"q");
        LOGGER.debug("Received CQL-based query [{}]", (Object)cqlStr);
        try {
            Filter filter = ECQL.toFilter((String)cqlStr);
            SearchUtils.addFilter(filters, (Filter)filter);
        }
        catch (CQLException cqlException) {
            throw new UnsupportedQueryException("Invalid CQL predicate provided.", (Throwable)cqlException);
        }
        return new CDRQueryCriteriaImpl((Filter)this.filterBuilder.allOf(filters), sortBy, cqlStr, true, queryParameters, new HashMap(), queryConfig);
    }
}

