/*
 * Decompiled with CFR 0.152.
 */
package org.codice.ddf.configuration.impl;

import java.util.Collections;
import java.util.Map;
import org.codice.ddf.configuration.ConfigurationWatcher;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;

public class ConfigurationWatcherImpl
implements ConfigurationWatcher {
    private static final XLogger logger = new XLogger(LoggerFactory.getLogger(ConfigurationWatcherImpl.class));
    private Map<String, String> propertyMap = Collections.EMPTY_MAP;
    private String hostname = null;
    private Integer port = null;
    private String protocol = null;
    private String schemeFromProtocol = null;
    private String siteName = null;
    private String version = null;
    private String organization = null;
    private String contactInfo = null;

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSchemeFromProtocol() {
        return this.schemeFromProtocol;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getContactEmailAddress() {
        return this.contactInfo;
    }

    public String getConfigurationValue(String name) {
        return this.propertyMap.get(name);
    }

    public void configurationUpdateCallback(Map<String, String> properties) {
        logger.entry(new Object[]{"configurationUpdateCallback"});
        if (properties != null && !properties.isEmpty()) {
            int index;
            this.propertyMap = properties;
            logger.debug("Configuration values: {}", properties);
            String oldValue = this.hostname;
            this.hostname = properties.get("host");
            this.logConfigurationValue("host", oldValue, this.hostname);
            String portString = properties.get("port");
            try {
                this.port = portString != null && !portString.isEmpty() ? Integer.valueOf(Integer.parseInt(portString)) : null;
                this.logConfigurationValue("port", oldValue, this.port);
            }
            catch (NumberFormatException e) {
                logger.warn("Error Updating Configuration value for '{}', not a valid Integer [{}] reverting back to old value [{}]", new Object[]{"port", portString, this.port});
            }
            oldValue = this.protocol;
            this.protocol = properties.get("protocol");
            this.logConfigurationValue("protocol", oldValue, this.protocol);
            this.schemeFromProtocol = this.protocol != null ? ((index = this.protocol.indexOf(58)) > -1 ? this.protocol.substring(0, index) : this.protocol) : null;
            oldValue = this.siteName;
            this.siteName = properties.get("id");
            this.logConfigurationValue("id", oldValue, this.siteName);
            oldValue = this.version;
            this.version = properties.get("version");
            this.logConfigurationValue("version", oldValue, this.version);
            oldValue = this.organization;
            this.organization = properties.get("organization");
            this.logConfigurationValue("organization", oldValue, this.organization);
            oldValue = this.contactInfo;
            this.contactInfo = properties.get("contact");
            this.logConfigurationValue("contact", oldValue, this.contactInfo);
        } else {
            this.propertyMap.clear();
            this.hostname = null;
            this.port = null;
            this.protocol = null;
            this.schemeFromProtocol = null;
            this.siteName = null;
            this.version = null;
            this.organization = null;
            this.contactInfo = null;
            logger.debug("Platform Configuration Properties are NULL or empty, setting all values to null");
        }
        logger.exit();
    }

    protected void logConfigurationValue(String propertyName, Object oldValue, Object newValue) {
        logger.debug("Updating Configuration value '{}' oldValue = [{}], newValue = [{}]", new Object[]{propertyName, oldValue, newValue});
    }
}

