/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.util;

import ddf.catalog.filter.impl.SortByImpl;
import ddf.catalog.operation.Query;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.source.UnsupportedQueryException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.di2e.ecdr.api.config.DateTypeConfiguration;
import net.di2e.ecdr.api.config.SortTypeConfiguration;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchUtils.class);
    private static final String MAP_ENTRY_DELIMITER = "=";
    private static DateTimeFormatter formatter;

    private SearchUtils() {
    }

    public static Map<String, Serializable> getTransformLinkProperties(UriInfo uriInfo, Query query, QueryResponse response, String scheme, String host, Integer port) {
        String template;
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        uriBuilder = SearchUtils.updateURLWithPlatformValues(uriBuilder, scheme, host, port);
        String selfLink = uriBuilder.toTemplate();
        properties.put("self", (Serializable)((Object)selfLink));
        LOGGER.debug("Adding self link parameter[{}] with value [{}] to transform properties to be sent to result transformer", (Object)"self", (Object)selfLink);
        int startIndex = query.getStartIndex();
        int pageSize = query.getPageSize();
        long totalCount = response.getHits();
        if ((long)(startIndex + pageSize) <= totalCount) {
            template = uriBuilder.replaceQueryParam("startIndex", new Object[]{String.valueOf(startIndex + pageSize)}).toTemplate();
            properties.put("next", (Serializable)((Object)template));
            LOGGER.debug("Adding next link parameter[{}] with value [{}] to transform properties to be sent to result transformer", (Object)"next", (Object)template);
        }
        if (startIndex > 1) {
            template = uriBuilder.replaceQueryParam("startIndex", new Object[]{String.valueOf(Math.max(1, startIndex - pageSize))}).toTemplate();
            properties.put("previous", (Serializable)((Object)template));
            LOGGER.debug("Adding previous link parameter[{}] with value [{}] to transform properties to be sent to result transformer", (Object)"previous", (Object)template);
        }
        return properties;
    }

    public static UriBuilder updateURLWithPlatformValues(UriBuilder builder, String scheme, String host, Integer port) {
        if (StringUtils.isNotBlank((String)scheme) && StringUtils.isNotBlank((String)host)) {
            LOGGER.debug("Using values from Platform Configuration for Atom Links host[" + host + "], scheme[" + scheme + "], and port[" + port + "]");
            builder.scheme(scheme);
            builder.host(host);
            if (port != null) {
                builder.port(port.intValue());
            }
        }
        return builder;
    }

    public static Boolean getBoolean(String booleanString, Boolean defaultValue) {
        Boolean bool = null;
        if (booleanString != null) {
            if ("1".equals(booleanString = booleanString.trim()) || Boolean.TRUE.toString().equalsIgnoreCase(booleanString)) {
                bool = Boolean.TRUE;
            } else if ("0".equals(booleanString) || Boolean.FALSE.toString().equalsIgnoreCase(booleanString)) {
                bool = Boolean.FALSE;
            }
        }
        return bool != null ? bool : defaultValue;
    }

    public static Map<String, String> convertToMap(String mapStr) {
        Map<String, String> inputMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)mapStr)) {
            inputMap = SearchUtils.convertToMap(Arrays.asList(mapStr.split(",")));
        }
        return inputMap;
    }

    public static Map<String, String> convertToMap(List<String> mapList) {
        HashMap<String, String> inputMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(mapList)) {
            for (String sortPair : mapList) {
                String[] pairAry = sortPair.split(MAP_ENTRY_DELIMITER);
                if (pairAry.length == 2) {
                    inputMap.put(StringUtils.trimToEmpty((String)pairAry[0]), StringUtils.trimToEmpty((String)pairAry[1]));
                    continue;
                }
                LOGGER.warn("Could not parse out map entry from {}, skipping this item.", (Object)sortPair);
            }
        }
        return inputMap;
    }

    public static Map<String, String> convertDateTypeToMap(List<DateTypeConfiguration> dateTypeList) {
        HashMap<String, String> inputMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(dateTypeList)) {
            for (DateTypeConfiguration dateType : dateTypeList) {
                inputMap.put(dateType.getCDRDateType(), dateType.getInternalDateType());
            }
        }
        return inputMap;
    }

    public static <T extends Enum<?>> T enumEqualsIgnoreCase(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (!StringUtils.equalsIgnoreCase((String)each.name(), (String)search)) continue;
            return (T)each;
        }
        return null;
    }

    public static Date parseDate(String date) throws UnsupportedQueryException {
        Date returnDate = null;
        if (StringUtils.isNotBlank((String)date)) {
            try {
                returnDate = formatter.parseDateTime(date).toDate();
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Could not process date because of invalid format [{}]", (Object)date);
                throw new UnsupportedQueryException("Invalid date format [" + date + "]");
            }
        }
        return returnDate;
    }

    public static SortBy getSortBy(String sortByString, List<SortTypeConfiguration> sortTypeConfigurationList, boolean supportWildcards) {
        SortTypeConfiguration sortType;
        String[] sortValues;
        String sortKey;
        SortByImpl sortBy = null;
        if (StringUtils.isNotBlank((String)sortByString) && StringUtils.isNotBlank((String)(sortKey = (sortValues = sortByString.split(","))[0])) && (sortType = SearchUtils.getSortConfiguration(sortKey, sortTypeConfigurationList, supportWildcards)) != null) {
            String sortAttribute = sortType.getSortAttribute();
            SortOrder sortOrder = null;
            sortOrder = sortValues.length >= 3 ? (Boolean.FALSE.toString().equalsIgnoreCase(sortValues[2]) ? SortOrder.DESCENDING : SortOrder.ASCENDING) : SortOrder.valueOf((String)sortType.getSortOrder());
            sortBy = new SortByImpl(sortAttribute, sortOrder);
        }
        return sortBy;
    }

    public static void logSort(SortBy sortBy) {
        if (LOGGER.isDebugEnabled()) {
            if (sortBy != null) {
                LOGGER.debug("SortBy for query is set to [{}]", (Object)(sortBy.getPropertyName().getPropertyName() + "/" + sortBy.getSortOrder()));
            } else {
                LOGGER.debug("SortBy for query is set to null");
            }
        }
    }

    private static SortTypeConfiguration getSortConfiguration(String sortKey, List<SortTypeConfiguration> sortTypeConfigurationList, boolean supportWildcard) {
        for (SortTypeConfiguration sortType : sortTypeConfigurationList) {
            String configSortKey = sortType.getSortKey();
            LOGGER.trace("Comparing incoming sort key of {} with configuration of key {}", (Object)sortKey, (Object)configSortKey);
            if (supportWildcard) {
                if (configSortKey.startsWith("*")) {
                    configSortKey = StringUtils.substringAfterLast((String)configSortKey, (String)"/");
                    if (sortKey.contains("/")) {
                        sortKey = StringUtils.substringAfterLast((String)sortKey, (String)"/");
                    }
                }
                LOGGER.trace("SortKeys being compated after wildcard normalization query sortKey=[{}] and configuration sortKey=[{}]", (Object)sortKey, (Object)configSortKey);
            }
            if (!StringUtils.equalsIgnoreCase((String)configSortKey, (String)sortKey)) continue;
            return sortType;
        }
        return null;
    }

    protected static boolean isBoolean(String value) {
        boolean isBoolean = false;
        if (StringUtils.isNotBlank((String)value)) {
            isBoolean = (value = value.toLowerCase()).equals("false") || value.equals("true") || value.equals("0") || value.equals("1");
        }
        return isBoolean;
    }

    public static boolean isBooleanNullOrBlank(String value) {
        boolean isBoolOrNull = true;
        if (StringUtils.isNotBlank((String)value)) {
            isBoolOrNull = SearchUtils.isBoolean(value);
        }
        return isBoolOrNull;
    }

    public static Boolean getBoolean(String booleanString) {
        Boolean bool = null;
        if (booleanString != null) {
            if ("1".equals(booleanString = booleanString.trim()) || Boolean.TRUE.toString().equalsIgnoreCase(booleanString)) {
                bool = Boolean.TRUE;
            } else if ("0".equals(booleanString) || Boolean.FALSE.toString().equalsIgnoreCase(booleanString)) {
                bool = Boolean.FALSE;
            }
        }
        return bool;
    }

    public static void addFilter(List<Filter> filters, Filter filter) {
        if (filter != null) {
            LOGGER.debug("Filter was not null, and will be added to the list of valid filters");
            filters.add(filter);
        } else {
            LOGGER.debug("Filter was null, not adding to the Filter list");
        }
    }

    public static String getAllowedSortValues(List<SortTypeConfiguration> sortTypes) {
        StringBuilder sb = new StringBuilder();
        for (SortTypeConfiguration sortType : sortTypes) {
            sb.append("'" + sortType.getSortKey() + "' ");
        }
        return sb.toString();
    }

    static {
        DateTimeParser[] parsers = new DateTimeParser[]{ISODateTimeFormat.date().getParser(), ISODateTimeFormat.dateTime().getParser(), ISODateTimeFormat.dateTimeNoMillis().getParser(), ISODateTimeFormat.basicDateTime().getParser(), ISODateTimeFormat.basicDateTimeNoMillis().getParser()};
        formatter = new DateTimeFormatterBuilder().append(null, parsers).toFormatter();
    }
}

