/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.di2e.ecdr.api.config.DateTypeConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DateTypeMap {
    private Map<String, DateTypeConfiguration> dateMap = new HashMap<String, DateTypeConfiguration>();
    private BundleContext context = null;

    public DateTypeMap(BundleContext bc) {
        this.context = bc;
    }

    public DateTypeConfiguration getConfiguration(String key) {
        return this.dateMap.get(key);
    }

    public String getMappedValue(String key) {
        DateTypeConfiguration config = this.dateMap.get(key);
        if (config != null) {
            return config.getInternalDateType();
        }
        return null;
    }

    public void addConfiguration(ServiceReference<DateTypeConfiguration> ref) {
        if (ref != null) {
            DateTypeConfiguration config = (DateTypeConfiguration)this.context.getService(ref);
            this.dateMap.put(config.getCDRDateType(), config);
        }
    }

    public void removeConfiguration(ServiceReference<DateTypeConfiguration> ref) {
        if (ref != null) {
            DateTypeConfiguration config = (DateTypeConfiguration)this.context.getService(ref);
            this.dateMap.remove(config.getCDRDateType());
        }
    }

    public Set<String> keySet() {
        return this.dateMap.keySet();
    }

    public boolean containsKey(String key) {
        return this.dateMap.containsKey(key);
    }
}

