/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.query.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRequestCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRequestCache.class);
    private static LRUCache<String, Boolean> cache = null;

    public QueryRequestCache(int cacheSize) {
        cache = new LRUCache(cacheSize);
    }

    public boolean isQueryIdUnique(String id) {
        boolean unique = true;
        if (StringUtils.isNotBlank((String)id)) {
            if (cache.containsKey(id)) {
                unique = false;
            } else {
                this.add(id);
            }
        }
        LOGGER.debug("Checking uniqueness of query with {}=[{}] and returning value for isUnique={}", new Object[]{"oid", id, unique});
        return unique;
    }

    public void updateCacheSize(int capacity) {
        cache.updateCacheSize(capacity);
    }

    public void add(String id) {
        cache.put(id, Boolean.TRUE);
    }

    private static final class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int cacheSize = 0;

        public LRUCache(int capacity) {
            super(capacity + 1, 1.1f, true);
            this.cacheSize = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cacheSize;
        }

        @Override
        public V put(K k, V v) {
            if (this.cacheSize > 0) {
                LOGGER.debug("Adding the queryId value to query request cache [{}]", k);
                return super.put(k, v);
            }
            return null;
        }

        public void updateCacheSize(int size) {
            this.clear();
            LOGGER.debug("Updating the query request cache size from [{}]  to [{}]", (Object)this.cacheSize, (Object)size);
            this.cacheSize = size;
        }
    }
}

