/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.query;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.api.query.QueryConfiguration;
import net.di2e.ecdr.commons.util.SearchUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryConfigurationImpl
implements QueryConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryConfigurationImpl.class);
    private int defaultCount = 100;
    private long defaultTimeoutMillis = 300000L;
    private String defaultDateType = "effective";
    private String defaultDateTypeCustom = null;
    private double defaultRadius = 50000.0;
    private String defaultResponseFormat = "cdr-atom";
    private String defaultResponseFormatCustom = null;
    private boolean defaultFuzzySearch = true;
    private boolean defaultDeduplication = false;
    private String defaultQueryLanguage = "cdr-kw-basic-2.0";
    private String defaultQueryLanguageCustom = null;
    private int queryRequestCacheSize = 1000;
    private Map<String, String> parameterExtensionMap = SearchUtils.convertToMap("uid=id");
    private List<String> parameterPropertyList = Arrays.asList("oid", "path");
    private List<String> headerPropertyList = Arrays.asList("EMID");

    public int getDefaultCount() {
        return this.defaultCount;
    }

    public void setDefaultCount(int count) {
        LOGGER.debug("ConfigUpdate: Updating the default count to [{}]", (Object)this.defaultCount);
        this.defaultCount = count;
    }

    public long getDefaultTimeoutMillis() {
        return this.defaultTimeoutMillis;
    }

    public void setDefaultTimeoutSeconds(long seconds) {
        LOGGER.debug("ConfigUpdate: Updating the default timeout (in seconds) to [{}]", (Object)seconds);
        this.defaultTimeoutMillis = seconds * 1000L;
    }

    public String getDefaultDateType() {
        return StringUtils.defaultIfBlank((String)this.defaultDateTypeCustom, (String)this.defaultDateType);
    }

    public void setDefaultDateType(String dateType) {
        if (StringUtils.isNotBlank((String)dateType)) {
            LOGGER.debug("ConfigUpdate: Updating the default dateType to [{}]", (Object)dateType);
            this.defaultDateType = dateType;
        } else {
            LOGGER.debug("ConfigUpdateError: Configuration update for defaultDateType in endpoint was empty or null so leaving at existing value for [{}]", (Object)this.defaultDateType);
        }
    }

    public void setDefaultDateTypeCustom(String dateType) {
        LOGGER.debug("ConfigUpdate: Updating the default dateType custom value to [{}]", (Object)dateType);
        this.defaultDateTypeCustom = dateType;
    }

    public double getDefaultRadius() {
        return this.defaultRadius;
    }

    public void setDefaultRadiusMeters(double radius) {
        LOGGER.debug("ConfigUpdate: Updating the default radius (in meters) to [{}]", (Object)radius);
        this.defaultRadius = radius;
    }

    public String getDefaultResponseFormat() {
        return StringUtils.defaultIfBlank((String)this.defaultResponseFormatCustom, (String)this.defaultResponseFormat);
    }

    public void setDefaultResponseFormat(String format) {
        if (StringUtils.isNotBlank((String)format)) {
            LOGGER.debug("ConfigUpdate: Updating the default response format to [{}]", (Object)format);
            this.defaultResponseFormat = format;
        } else {
            LOGGER.debug("ConfigUpdateError: Configuration update for defaultResponseFormat in endpoint was empty or null so leaving at existing value for [{}]", (Object)this.defaultResponseFormat);
        }
    }

    public void setDefaultResponseFormatCustom(String format) {
        LOGGER.debug("ConfigUpdate: Updating the default response format custom override value to [{}]", (Object)format);
        this.defaultResponseFormatCustom = format;
    }

    public boolean isDefaultFuzzySearch() {
        return this.defaultFuzzySearch;
    }

    public void setDefaultFuzzySearch(boolean fuzzy) {
        LOGGER.debug("ConfigUpdate: Updating the default fuzzy search value to [{}]", (Object)fuzzy);
        this.defaultFuzzySearch = fuzzy;
    }

    public boolean isDefaultDeduplication() {
        return this.defaultDeduplication;
    }

    public void setDefaultDeduplication(boolean dedup) {
        LOGGER.debug("ConfigUpdate: Updating the default deduplication value to [{}]", (Object)dedup);
        this.defaultDeduplication = dedup;
    }

    public String getDefaultQueryLanguage() {
        return StringUtils.defaultIfBlank((String)this.defaultQueryLanguageCustom, (String)this.defaultQueryLanguage);
    }

    public void setDefaultQueryLanguage(String lang) {
        LOGGER.debug("ConfigUpdate: Updating the default query language to [{}]", (Object)lang);
        this.defaultQueryLanguage = lang;
    }

    public void setDefaultQueryLanguageCustom(String lang) {
        LOGGER.debug("ConfigUpdate: Updating the default query language custom value to [{}]", (Object)lang);
        this.defaultQueryLanguageCustom = lang;
    }

    public Map<String, String> getParameterExtensionMap() {
        return this.parameterExtensionMap;
    }

    public void setParameterExtensionMap(List<String> paramList) {
        Map<String, String> paramMap = SearchUtils.convertToMap(paramList);
        LOGGER.debug("ConfigUpdate: Updating the default parameter extension map value to [{}]", paramMap);
        this.parameterExtensionMap = paramMap;
    }

    public List<String> getParameterPropertyList() {
        return this.parameterPropertyList;
    }

    public void setParameterPropertyList(List<String> propList) {
        LOGGER.debug("ConfigUpdate: Updating the default parameter property map value to [{}]", propList);
        this.parameterPropertyList = propList;
    }

    public List<String> getHeaderPropertyList() {
        return this.headerPropertyList;
    }

    public void setHeaderPropertyList(List<String> propList) {
        LOGGER.debug("ConfigUpdate: Updating the default HTTP Header property map value to [{}]", propList);
        this.headerPropertyList = propList;
    }

    public int getQueryRequestCacheSize() {
        return this.queryRequestCacheSize;
    }

    public void setQueryRequestCacheSize(int size) {
        LOGGER.debug("ConfigUpdate: Updating the query request cache size value to [{}]", (Object)size);
        this.queryRequestCacheSize = size;
    }
}

