/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.query;

import ddf.catalog.operation.Query;
import ddf.catalog.source.UnsupportedQueryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.MultivaluedMap;
import net.di2e.ecdr.api.query.QueryCriteria;
import net.di2e.ecdr.commons.util.SearchUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.sort.SortBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDRQueryImpl
implements Query {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDRQueryImpl.class);
    private QueryCriteria queryCriteria = null;
    private StringBuilder humanReadableQueryBuilder = null;
    private Collection<String> sources = null;
    private int count;
    private String responseFormat;
    private long timeoutMilliseconds;
    private boolean isStrictMode = false;
    private int startIndex;

    public CDRQueryImpl(QueryCriteria crit, String localSourceId) throws UnsupportedQueryException {
        this.queryCriteria = crit;
        MultivaluedMap queryParameters = this.queryCriteria.getParameterValues();
        this.humanReadableQueryBuilder = new StringBuilder(StringUtils.defaultString((String)this.queryCriteria.getHumanReadableQuery()));
        this.populateStrictMode((MultivaluedMap<String, String>)queryParameters);
        this.appendParameter("strict", this.isStrictMode);
        this.populateResponseFormat((MultivaluedMap<String, String>)queryParameters);
        this.appendParameter("format", this.responseFormat);
        this.populateStartIndex((MultivaluedMap<String, String>)queryParameters);
        this.appendParameter("startIndex", this.startIndex);
        this.populateCount((MultivaluedMap<String, String>)queryParameters);
        this.appendParameter("count", this.count);
        this.populateTimeoutMilliseconds((MultivaluedMap<String, String>)queryParameters);
        this.appendParameter("timeout", this.timeoutMilliseconds);
        boolean includeStatus = this.isIncludeStatus((MultivaluedMap<String, String>)queryParameters);
        this.appendParameter("status", includeStatus);
        this.populateSourceList((MultivaluedMap<String, String>)this.queryCriteria.getParameterValues());
        if (CollectionUtils.isNotEmpty(this.sources)) {
            this.appendParameter("source", StringUtils.join(this.sources, (String)", "));
        }
    }

    protected void appendParameter(String parameter, Object value) {
        this.humanReadableQueryBuilder.append(" " + parameter + "=[" + value + "] ");
    }

    public boolean evaluate(Object object) {
        return this.queryCriteria.getFilter().evaluate(object);
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return this.queryCriteria.getFilter().accept(visitor, extraData);
    }

    public int getPageSize() {
        return this.count;
    }

    public SortBy getSortBy() {
        return this.queryCriteria.getSortBy();
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public long getTimeoutMillis() {
        return this.timeoutMilliseconds;
    }

    public boolean requestsTotalResultsCount() {
        return true;
    }

    public boolean getStrictMode() {
        return this.isStrictMode;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public String getHumanReadableQuery() {
        return this.humanReadableQueryBuilder.toString();
    }

    public Collection<String> getSiteNames() {
        return this.sources;
    }

    protected void populateSourceList(MultivaluedMap<String, String> queryParameters) {
        this.sources = new ArrayList<String>();
        String sourceString = (String)queryParameters.getFirst((Object)"source");
        if (sourceString != null && !sourceString.isEmpty()) {
            String[] sourceArray = sourceString.split(",");
            this.sources = Arrays.asList(sourceArray);
        }
    }

    protected void populateTimeoutMilliseconds(MultivaluedMap<String, String> queryParameters) throws UnsupportedQueryException {
        block5: {
            String timeout = (String)queryParameters.getFirst((Object)"timeout");
            this.timeoutMilliseconds = this.queryCriteria.getQueryConfiguration().getDefaultTimeoutMillis();
            LOGGER.debug("Attempting to set 'timeout' value from request [" + timeout + "] to long");
            if (StringUtils.isNotBlank((String)timeout)) {
                try {
                    this.timeoutMilliseconds = Long.parseLong(timeout);
                    if (this.timeoutMilliseconds <= 0L) {
                        throw new UnsupportedQueryException("The [timeout] parameter cannot nbe less than 0 and was [" + timeout + "]");
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    String message = "Invalid Number found for 'timeout' [" + timeout + "].  Resulted in exception: " + e.getMessage();
                    LOGGER.warn(message);
                    if (this.isStrictMode) {
                        throw new UnsupportedQueryException(message);
                    }
                    break block5;
                }
            }
            LOGGER.debug("'timeout' parameter was not specified, defaulting value to [{}]", (Object)timeout);
        }
    }

    protected void populateResponseFormat(MultivaluedMap<String, String> queryParameters) {
        String format = (String)queryParameters.getFirst((Object)"format");
        this.responseFormat = StringUtils.defaultIfBlank((String)format, (String)this.queryCriteria.getQueryConfiguration().getDefaultResponseFormat());
    }

    protected void populateStartIndex(MultivaluedMap<String, String> queryParameters) throws UnsupportedQueryException {
        String indexString = (String)queryParameters.getFirst((Object)"startIndex");
        int index = 1;
        LOGGER.debug("Attempting to set 'startIndex' value from request [{}] to int", (Object)indexString);
        if (StringUtils.isNotBlank((String)indexString)) {
            try {
                index = Integer.parseInt(indexString);
            }
            catch (NumberFormatException e) {
                String message = "Invalid Number found for 'startIndex' [" + indexString + "].  Resulted in exception: " + e.getMessage();
                LOGGER.warn(message);
                throw new UnsupportedQueryException(message);
            }
        } else {
            LOGGER.debug("'startIndex' parameter was not specified, defaulting value to [{}]", (Object)index);
        }
        this.startIndex = index < 1 ? 1 : index;
    }

    protected void populateCount(MultivaluedMap<String, String> queryParameters) throws UnsupportedQueryException {
        String stringCount = (String)queryParameters.getFirst((Object)"count");
        this.count = this.queryCriteria.getQueryConfiguration().getDefaultCount();
        LOGGER.debug("Attempting to set 'count' value from request [{}] to int", (Object)stringCount);
        if (StringUtils.isNotBlank((String)stringCount)) {
            try {
                this.count = Integer.parseInt(stringCount);
            }
            catch (NumberFormatException e) {
                String message = "Invalid Number found for 'count' [" + stringCount + "].  Resulted in exception: " + e.getMessage();
                LOGGER.warn(message);
                throw new UnsupportedQueryException(message);
            }
        } else {
            LOGGER.debug("'count' parameter was not specified, defaulting value to [{}]", (Object)this.count);
        }
    }

    protected void populateStrictMode(MultivaluedMap<String, String> queryParameters) {
        this.isStrictMode = BooleanUtils.toBooleanDefaultIfNull((Boolean)SearchUtils.getBoolean((String)queryParameters.getFirst((Object)"strict")), (boolean)false);
    }

    protected boolean isIncludeStatus(MultivaluedMap<String, String> queryParameters) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)SearchUtils.getBoolean((String)queryParameters.getFirst((Object)"status")), (boolean)true);
    }
}

