/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.filter;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import ddf.catalog.filter.FilterDelegate;
import java.util.Date;
import java.util.List;
import net.di2e.ecdr.commons.filter.StrictFilterDelegate;
import net.di2e.ecdr.commons.filter.config.AtomSearchResponseTransformerConfig;
import net.di2e.ecdr.commons.util.GeospatialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilterDelegate<T>
extends FilterDelegate<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrictFilterDelegate.class);
    private double defaultRadiusforNN = 0.0;
    private SupportedGeosOptions supportedGeoOptions = null;
    private AtomSearchResponseTransformerConfig filterConfig = null;

    public AbstractFilterDelegate(double defaultRadiusforNN, SupportedGeosOptions supportedGeos) {
        this.defaultRadiusforNN = defaultRadiusforNN;
        this.supportedGeoOptions = supportedGeos == null ? SupportedGeosOptions.ALL : supportedGeos;
    }

    public abstract T handlePropertyLike(String var1, String var2, StringFilterOptions var3);

    public abstract T handlePropertyEqualToString(String var1, String var2, StringFilterOptions var3);

    public abstract T handlePropertyIsEqualToNumber(String var1, double var2);

    public abstract T handlePropertyIsNotEqualToString(String var1, String var2, boolean var3);

    public abstract T handlePropertyIsNotEqualToNumber(String var1, double var2);

    public abstract T handlePropertyIsGreaterThanString(String var1, String var2, boolean var3);

    public abstract T handlePropertyIsGreaterThanNumber(String var1, double var2, boolean var4);

    public abstract T handlePropertyIsLessThanString(String var1, String var2, boolean var3);

    public abstract T handlePropertyIsLessThanNumber(String var1, double var2, boolean var4);

    public abstract T handlePropertyBetweenString(String var1, String var2, String var3);

    public abstract T handleNumericRange(String var1, double var2, double var4);

    public abstract T handleTimeDuring(String var1, Date var2, Date var3);

    public abstract T handleTimeAfter(String var1, Date var2, boolean var3);

    public abstract T handleTimeBefore(String var1, Date var2, boolean var3);

    public abstract T handleTimeNotDuring(String var1, Date var2, Date var3);

    public abstract T handleGeospatial(String var1, String var2, GeospatialFilterOptions var3);

    public abstract T handleGeospatialDistance(String var1, String var2, double var3, GeospatialDistanceFilterOptions var5);

    public abstract T handleXpath(String var1, String var2, StringFilterOptions var3);

    public abstract T handleAnd(List<T> var1);

    public abstract T handleOr(List<T> var1);

    public abstract T handleNot(T var1);

    public T and(List<T> operands) {
        this.logEntry("and", operands.toString(), null);
        return this.handleAnd(operands);
    }

    public T or(List<T> operands) {
        this.logEntry("or", operands.toString(), null);
        return this.handleOr(operands);
    }

    public T not(T operand) {
        this.logEntry("not", operand.toString(), null);
        return this.handleNot(operand);
    }

    public T include() {
        this.logEntry("include", null, null);
        throw new UnsupportedOperationException("include() not supported by Filter Delegate.");
    }

    public T exclude() {
        this.logEntry("exclude", null, null);
        throw new UnsupportedOperationException("exclude() not supported by Filter Delegate.");
    }

    public T propertyIsEqualTo(String propertyName, String literal, boolean isCaseSensitive) {
        this.logEntry("propertyIsEqualTo", propertyName, (Object)literal, isCaseSensitive);
        return this.handlePropertyEqualToString(propertyName, literal, isCaseSensitive ? StringFilterOptions.CASE_SENSITIVE : null);
    }

    public T propertyIsEqualTo(String propertyName, Date literal) {
        this.logEntry("propertyIsEqualTo_Date", propertyName, literal);
        return this.handleTimeDuring(propertyName, literal, literal);
    }

    public T propertyIsEqualTo(String propertyName, Date startDate, Date endDate) {
        this.logEntry("propertyIsEqualTo_Dates", propertyName, (Object)startDate, endDate);
        return this.handleTimeDuring(propertyName, startDate, endDate);
    }

    public T propertyIsEqualTo(String propertyName, int literal) {
        this.logEntry("propertyIsEqualTo_int", propertyName, literal);
        return this.handlePropertyIsEqualToNumber(propertyName, literal);
    }

    public T propertyIsEqualTo(String propertyName, short literal) {
        this.logEntry("propertyIsEqualTo_short", propertyName, literal);
        return this.handlePropertyIsEqualToNumber(propertyName, literal);
    }

    public T propertyIsEqualTo(String propertyName, long literal) {
        this.logEntry("propertyIsEqualTo_long", propertyName, literal);
        return this.handlePropertyIsEqualToNumber(propertyName, literal);
    }

    public T propertyIsEqualTo(String propertyName, float literal) {
        this.logEntry("propertyIsEqualTo_float", propertyName, Float.valueOf(literal));
        return this.handlePropertyIsEqualToNumber(propertyName, literal);
    }

    public T propertyIsEqualTo(String propertyName, double literal) {
        this.logEntry("propertyIsEqualTo_double", propertyName, literal);
        return this.handlePropertyIsEqualToNumber(propertyName, literal);
    }

    public T propertyIsEqualTo(String propertyName, boolean literal) {
        this.logEntry("propertyIsEqualTo_boolean", propertyName, literal);
        return this.handlePropertyEqualToString(propertyName, String.valueOf(literal), null);
    }

    public T propertyIsEqualTo(String propertyName, byte[] literal) {
        this.logEntry("propertyIsEqualTo_Bytes", propertyName, literal);
        throw new UnsupportedOperationException("propertyIsEqualTo(String, byte[]) not supported by Filter Delegate.");
    }

    public T propertyIsEqualTo(String propertyName, Object literal) {
        this.logEntry("propertyIsEqualTo_Object", propertyName, literal);
        return this.handlePropertyEqualToString(propertyName, String.valueOf(literal), null);
    }

    public T propertyIsNotEqualTo(String propertyName, String literal, boolean isCaseSensitive) {
        this.logEntry("propertyIsNotEqualTo", propertyName, (Object)literal, isCaseSensitive);
        return this.handlePropertyIsNotEqualToString(propertyName, literal, isCaseSensitive);
    }

    public T propertyIsNotEqualTo(String propertyName, Date literal) {
        this.logEntry("propertyIsEqualTo_Date", propertyName, literal);
        throw new UnsupportedOperationException("propertyIsNotEqualTo(String, Date) not supported by Filter Delegate.");
    }

    public T propertyIsNotEqualTo(String propertyName, Date startDate, Date endDate) {
        this.logEntry("propertyIsNotEqualTo_Dates", propertyName, (Object)startDate, endDate);
        throw new UnsupportedOperationException("propertyIsNotEqualTo(String, Date, Date) not supported by Filter Delegate.");
    }

    public T propertyIsNotEqualTo(String propertyName, int literal) {
        this.logEntry("propertyIsNotEqualTo_int", propertyName, literal);
        return this.handlePropertyIsNotEqualToNumber(propertyName, literal);
    }

    public T propertyIsNotEqualTo(String propertyName, short literal) {
        this.logEntry("propertyIsNotEqualTo_short", propertyName, literal);
        return this.handlePropertyIsNotEqualToNumber(propertyName, literal);
    }

    public T propertyIsNotEqualTo(String propertyName, long literal) {
        this.logEntry("propertyIsNotEqualTo_long", propertyName, literal);
        return this.handlePropertyIsNotEqualToNumber(propertyName, literal);
    }

    public T propertyIsNotEqualTo(String propertyName, float literal) {
        this.logEntry("propertyIsNotEqualTo_float", propertyName, Float.valueOf(literal));
        return this.handlePropertyIsNotEqualToNumber(propertyName, literal);
    }

    public T propertyIsNotEqualTo(String propertyName, double literal) {
        this.logEntry("propertyIsNotEqualTo_double", propertyName, literal);
        return this.handlePropertyIsNotEqualToNumber(propertyName, literal);
    }

    public T propertyIsNotEqualTo(String propertyName, boolean literal) {
        this.logEntry("propertyIsNotEqualTo_boolean", propertyName, literal);
        return this.handlePropertyIsNotEqualToString(propertyName, String.valueOf(literal), false);
    }

    public T propertyIsNotEqualTo(String propertyName, byte[] literal) {
        this.logEntry("propertyIsNotEqualTo_Bytes", propertyName, literal);
        throw new UnsupportedOperationException("propertyIsNotEqualTo(String, byte[]) not supported by Filter Delegate.");
    }

    public T propertyIsNotEqualTo(String propertyName, Object literal) {
        this.logEntry("propertyIsNotEqualTo", propertyName, literal);
        throw new UnsupportedOperationException("propertyIsNotEqualTo(String, Object) not supported by Filter Delegate.");
    }

    public T propertyIsGreaterThan(String propertyName, String literal) {
        this.logEntry("propertyIsGreaterThan", propertyName, literal);
        return this.handlePropertyIsGreaterThanString(propertyName, literal, false);
    }

    public T propertyIsGreaterThan(String propertyName, Date literal) {
        this.logEntry("propertyIsGreaterThan_Date", propertyName, literal);
        return this.handleTimeAfter(propertyName, literal, false);
    }

    public T propertyIsGreaterThan(String propertyName, int literal) {
        this.logEntry("propertyIsGreaterThan_int", propertyName, literal);
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, false);
    }

    public T propertyIsGreaterThan(String propertyName, short literal) {
        this.logEntry("propertyIsGreaterThan_short", propertyName, literal);
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, false);
    }

    public T propertyIsGreaterThan(String propertyName, long literal) {
        this.logEntry("propertyIsGreaterThan_long", propertyName, literal);
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, false);
    }

    public T propertyIsGreaterThan(String propertyName, float literal) {
        this.logEntry("propertyIsGreaterThan_float", propertyName, Float.valueOf(literal));
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, false);
    }

    public T propertyIsGreaterThan(String propertyName, double literal) {
        this.logEntry("propertyIsGreaterThan_double", propertyName, literal);
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, false);
    }

    public T propertyIsGreaterThan(String propertyName, Object literal) {
        this.logEntry("propertyIsGreaterThan_Object", propertyName, literal);
        throw new UnsupportedOperationException("propertyIsGreaterThan(String, Object) not supported by Filter Delegate.");
    }

    public T propertyIsGreaterThanOrEqualTo(String propertyName, String literal) {
        this.logEntry("propertyIsGreaterThanOrEqualTo", propertyName, literal);
        return this.handlePropertyIsGreaterThanString(propertyName, literal, true);
    }

    public T propertyIsGreaterThanOrEqualTo(String propertyName, Date literal) {
        this.logEntry("propertyIsGreaterThanOrEqualTo_Date", propertyName, literal);
        return this.handleTimeAfter(propertyName, literal, true);
    }

    public T propertyIsGreaterThanOrEqualTo(String propertyName, int literal) {
        this.logEntry("propertyIsGreaterThanOrEqualTo_int", propertyName, literal);
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, true);
    }

    public T propertyIsGreaterThanOrEqualTo(String propertyName, short literal) {
        this.logEntry("propertyIsGreaterThanOrEqualTo_short", propertyName, literal);
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, true);
    }

    public T propertyIsGreaterThanOrEqualTo(String propertyName, long literal) {
        this.logEntry("propertyIsGreaterThanOrEqualTo_long", propertyName, literal);
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, true);
    }

    public T propertyIsGreaterThanOrEqualTo(String propertyName, float literal) {
        this.logEntry("propertyIsGreaterThanOrEqualTo_float", propertyName, Float.valueOf(literal));
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, true);
    }

    public T propertyIsGreaterThanOrEqualTo(String propertyName, double literal) {
        this.logEntry("propertyIsGreaterThanOrEqualTo_double", propertyName, literal);
        return this.handlePropertyIsGreaterThanNumber(propertyName, literal, true);
    }

    public T propertyIsGreaterThanOrEqualTo(String propertyName, Object literal) {
        this.logEntry("propertyIsGreaterThanOrEqualTo_Object", propertyName, literal);
        throw new UnsupportedOperationException("propertyIsGreaterThanOrEqualTo(String, Object) not supported by Filter Delegate.");
    }

    public T propertyIsLessThan(String propertyName, String literal) {
        this.logEntry("propertyIsLessThan", propertyName, literal);
        return this.handlePropertyIsLessThanString(propertyName, literal, false);
    }

    public T propertyIsLessThan(String propertyName, Date literal) {
        this.logEntry("propertyIsLessThan_Date", propertyName, literal);
        return this.handleTimeBefore(propertyName, literal, false);
    }

    public T propertyIsLessThan(String propertyName, int literal) {
        this.logEntry("propertyIsLessThan_int", propertyName, literal);
        return this.handlePropertyIsLessThanNumber(propertyName, literal, false);
    }

    public T propertyIsLessThan(String propertyName, short literal) {
        this.logEntry("propertyIsLessThan_short", propertyName, literal);
        return this.handlePropertyIsLessThanNumber(propertyName, literal, false);
    }

    public T propertyIsLessThan(String propertyName, long literal) {
        this.logEntry("propertyIsLessThan_long", propertyName, literal);
        return this.handlePropertyIsLessThanNumber(propertyName, literal, false);
    }

    public T propertyIsLessThan(String propertyName, float literal) {
        this.logEntry("propertyIsLessThan_float", propertyName, Float.valueOf(literal));
        return this.handlePropertyIsLessThanNumber(propertyName, literal, false);
    }

    public T propertyIsLessThan(String propertyName, double literal) {
        this.logEntry("propertyIsLessThan_double", propertyName, literal);
        return this.handlePropertyIsLessThanNumber(propertyName, literal, false);
    }

    public T propertyIsLessThan(String propertyName, Object literal) {
        this.logEntry("propertyIsLessThan_Object", propertyName, literal);
        throw new UnsupportedOperationException("propertyIsLessThan(String, Object) not supported by Filter Delegate.");
    }

    public T propertyIsLessThanOrEqualTo(String propertyName, String literal) {
        this.logEntry("propertyIsLessThanOrEqualTo", propertyName, literal);
        return this.handlePropertyIsLessThanString(propertyName, literal, true);
    }

    public T propertyIsLessThanOrEqualTo(String propertyName, Date literal) {
        this.logEntry("propertyIsLessThanOrEqualTo_Date", propertyName, literal);
        return this.handleTimeBefore(propertyName, literal, true);
    }

    public T propertyIsLessThanOrEqualTo(String propertyName, int literal) {
        this.logEntry("propertyIsLessThanOrEqualTo_int", propertyName, literal);
        return this.handlePropertyIsLessThanNumber(propertyName, literal, true);
    }

    public T propertyIsLessThanOrEqualTo(String propertyName, short literal) {
        this.logEntry("propertyIsLessThanOrEqualTo_short", propertyName, literal);
        return this.handlePropertyIsLessThanNumber(propertyName, literal, true);
    }

    public T propertyIsLessThanOrEqualTo(String propertyName, long literal) {
        this.logEntry("propertyIsLessThanOrEqualTo_long", propertyName, literal);
        return this.handlePropertyIsLessThanNumber(propertyName, literal, true);
    }

    public T propertyIsLessThanOrEqualTo(String propertyName, float literal) {
        this.logEntry("propertyIsLessThanOrEqualTo_float", propertyName, Float.valueOf(literal));
        return this.handlePropertyIsLessThanNumber(propertyName, literal, true);
    }

    public T propertyIsLessThanOrEqualTo(String propertyName, double literal) {
        this.logEntry("propertyIsLessThanOrEqualTo_double", propertyName, literal);
        return this.handlePropertyIsLessThanNumber(propertyName, literal, true);
    }

    public T propertyIsLessThanOrEqualTo(String propertyName, Object literal) {
        this.logEntry("propertyIsLessThanOrEqualTo_Object", propertyName, literal);
        throw new UnsupportedOperationException("propertyIsLessThanOrEqualTo(String, Object) not supported by Filter Delegate.");
    }

    public T propertyIsBetween(String propertyName, String lowerBoundary, String upperBoundary) {
        this.logEntry("propertyIsBetween", propertyName, (Object)lowerBoundary, upperBoundary);
        return this.handlePropertyBetweenString(propertyName, lowerBoundary, upperBoundary);
    }

    public T propertyIsBetween(String propertyName, Date lowerBoundary, Date upperBoundary) {
        this.logEntry("propertyIsBetween_Dates", propertyName, (Object)lowerBoundary, upperBoundary);
        return this.handleTimeDuring(propertyName, lowerBoundary, upperBoundary);
    }

    public T propertyIsBetween(String propertyName, int lowerBoundary, int upperBoundary) {
        this.logEntry("propertyIsBetween_int", propertyName, (Object)lowerBoundary, upperBoundary);
        return this.handleNumericRange(propertyName, lowerBoundary, upperBoundary);
    }

    public T propertyIsBetween(String propertyName, short lowerBoundary, short upperBoundary) {
        this.logEntry("propertyIsBetween_short", propertyName, (Object)lowerBoundary, upperBoundary);
        return this.handleNumericRange(propertyName, lowerBoundary, upperBoundary);
    }

    public T propertyIsBetween(String propertyName, long lowerBoundary, long upperBoundary) {
        this.logEntry("propertyIsBetween_long", propertyName, (Object)lowerBoundary, upperBoundary);
        return this.handleNumericRange(propertyName, lowerBoundary, upperBoundary);
    }

    public T propertyIsBetween(String propertyName, float lowerBoundary, float upperBoundary) {
        this.logEntry("propertyIsBetween_float", propertyName, (Object)Float.valueOf(lowerBoundary), Float.valueOf(upperBoundary));
        return this.handleNumericRange(propertyName, lowerBoundary, upperBoundary);
    }

    public T propertyIsBetween(String propertyName, double lowerBoundary, double upperBoundary) {
        this.logEntry("propertyIsBetween_double", propertyName, (Object)lowerBoundary, upperBoundary);
        return this.handleNumericRange(propertyName, lowerBoundary, upperBoundary);
    }

    public T propertyIsBetween(String propertyName, Object lowerBoundary, Object upperBoundary) {
        this.logEntry("propertyIsBetween_Object", propertyName, lowerBoundary, upperBoundary);
        return this.handlePropertyBetweenString(propertyName, String.valueOf(lowerBoundary), String.valueOf(upperBoundary));
    }

    public T propertyIsNull(String propertyName) {
        this.logEntry("propertyIsNull", propertyName, null);
        return this.handlePropertyEqualToString(propertyName, null, null);
    }

    public T propertyIsLike(String propertyName, String pattern, boolean isCaseSensitive) {
        this.logEntry("propertyIsLike", propertyName, (Object)pattern, isCaseSensitive);
        return this.handlePropertyLike(propertyName, pattern, isCaseSensitive ? StringFilterOptions.CASE_SENSITIVE : null);
    }

    public T propertyIsFuzzy(String propertyName, String literal) {
        this.logEntry("propertyIsFuzzy", propertyName, literal);
        return this.handlePropertyEqualToString(propertyName, literal, StringFilterOptions.FUZZY);
    }

    public T xpathExists(String xpath) {
        this.logEntry("xpathExists", null, xpath);
        return this.handleXpath(xpath, null, null);
    }

    public T xpathIsLike(String xpath, String pattern, boolean isCaseSensitive) {
        this.logEntry("xpathIsLike", xpath, (Object)pattern, isCaseSensitive);
        return this.handleXpath(xpath, pattern, isCaseSensitive ? StringFilterOptions.CASE_SENSITIVE : null);
    }

    public T xpathIsFuzzy(String xpath, String literal) {
        this.logEntry("xpathIsFuzzy", xpath, literal);
        return this.handleXpath(xpath, literal, null);
    }

    public T beyond(String propertyName, String wkt, double distance) {
        this.logEntry("beyond", propertyName, (Object)wkt, distance);
        return this.callHandleGeoMethod(propertyName, wkt, distance, null, GeospatialDistanceFilterOptions.BEYOND);
    }

    protected T callHandleGeoMethod(String propertyName, String wkt, Double distance, GeospatialFilterOptions geoFilterOptions, GeospatialDistanceFilterOptions geoDistanceFilterOptions) {
        T returnValue = null;
        try {
            switch (this.supportedGeoOptions) {
                case ALL: {
                    returnValue = distance == null ? this.handleGeospatial(propertyName, wkt, geoFilterOptions) : this.handleGeospatialDistance(propertyName, wkt, distance, geoDistanceFilterOptions);
                    break;
                }
                case BBOX_ONLY: {
                    if (distance == null) {
                        wkt = GeospatialUtils.polygonToBBox(wkt);
                    } else {
                        wkt = GeospatialUtils.circleToBBox(wkt, distance);
                        geoFilterOptions = GeospatialFilterOptions.INTERSECTS;
                    }
                    returnValue = this.handleGeospatial(propertyName, wkt, geoFilterOptions);
                    break;
                }
                case POINT_RADUIS_AND_BBOX: {
                    if (distance == null) {
                        returnValue = this.handleGeospatial(propertyName, GeospatialUtils.polygonToBBox(wkt), geoFilterOptions);
                        break;
                    }
                    returnValue = this.handleGeospatialDistance(propertyName, wkt, distance, geoDistanceFilterOptions);
                    break;
                }
                case GEOMETRY_ONLY: {
                    if (distance != null) {
                        wkt = GeospatialUtils.circleToBBox(wkt, distance);
                        geoFilterOptions = GeospatialFilterOptions.INTERSECTS;
                    }
                    returnValue = this.handleGeospatial(propertyName, GeospatialUtils.polygonToBBox(wkt), geoFilterOptions);
                    break;
                }
                default: {
                    returnValue = distance == null ? this.handleGeospatial(propertyName, wkt, geoFilterOptions) : this.handleGeospatialDistance(propertyName, wkt, distance, geoDistanceFilterOptions);
                    break;
                }
            }
        }
        catch (ParseException e) {
            LOGGER.warn("WKT could not be parsed into a [{}] object wkt=[{}]: [{}]", new Object[]{this.supportedGeoOptions, wkt, e.getMessage()});
        }
        return returnValue;
    }

    public T contains(String propertyName, String wkt) {
        this.logEntry("contains", propertyName, wkt);
        return this.callHandleGeoMethod(propertyName, wkt, null, GeospatialFilterOptions.CONTAINS, null);
    }

    public T crosses(String propertyName, String wkt) {
        this.logEntry("crosses", propertyName, wkt);
        return this.callHandleGeoMethod(propertyName, wkt, null, GeospatialFilterOptions.CROSSES, null);
    }

    public T disjoint(String propertyName, String wkt) {
        this.logEntry("disjoint", propertyName, wkt);
        return this.callHandleGeoMethod(propertyName, wkt, null, GeospatialFilterOptions.DISJOINT, null);
    }

    public T dwithin(String propertyName, String wkt, double distance) {
        this.logEntry("dwithin", propertyName, (Object)wkt, distance);
        return this.callHandleGeoMethod(propertyName, wkt, distance, null, GeospatialDistanceFilterOptions.WITHIN);
    }

    public T nearestNeighbor(String propertyName, String wkt) {
        this.logEntry("nearestNeighbor", propertyName, wkt);
        return this.callHandleGeoMethod(propertyName, wkt, this.defaultRadiusforNN, null, GeospatialDistanceFilterOptions.WITHIN);
    }

    public T intersects(String propertyName, String wkt) {
        this.logEntry("intersects", propertyName, wkt);
        boolean isBbox = false;
        try {
            WKTReader reader = new WKTReader();
            isBbox = reader.read(wkt).isRectangle();
        }
        catch (ParseException e) {
            LOGGER.warn("WKT could not be parsed into geometry object [{}]: " + e.getMessage());
        }
        return this.callHandleGeoMethod(propertyName, wkt, null, isBbox ? GeospatialFilterOptions.BBOX : GeospatialFilterOptions.INTERSECTS, null);
    }

    public T overlaps(String propertyName, String wkt) {
        this.logEntry("overlaps", propertyName, wkt);
        return this.callHandleGeoMethod(propertyName, wkt, null, GeospatialFilterOptions.OVERLAPS, null);
    }

    public T touches(String propertyName, String wkt) {
        this.logEntry("touches", propertyName, wkt);
        return this.callHandleGeoMethod(propertyName, wkt, null, GeospatialFilterOptions.TOUCHES, null);
    }

    public T within(String propertyName, String wkt) {
        this.logEntry("within", propertyName, wkt);
        return this.callHandleGeoMethod(propertyName, wkt, null, GeospatialFilterOptions.WITHIN, null);
    }

    public T after(String propertyName, Date date) {
        this.logEntry("after", propertyName, date);
        return this.handleTimeAfter(propertyName, date, false);
    }

    public T before(String propertyName, Date date) {
        this.logEntry("before", propertyName, date);
        return this.handleTimeBefore(propertyName, date, false);
    }

    public T during(String propertyName, Date startDate, Date endDate) {
        this.logEntry("during", propertyName, (Object)startDate, endDate);
        return this.handleTimeDuring(propertyName, startDate, endDate);
    }

    public T relative(String propertyName, long duration) {
        this.logEntry("relative", propertyName, duration);
        return this.handleTimeAfter(propertyName, new Date(System.currentTimeMillis() - duration), true);
    }

    protected void logEntry(String method, String name, Object value) {
        this.logEntry(method, name, value, false);
    }

    protected void logEntry(String method, String name, Object value, boolean isCaseSensitive) {
        LOGGER.debug("ENTERING {}( propertyName=[{}" + (isCaseSensitive ? "_CaseSensitive" : "") + "] , value=[{}] )", new Object[]{method, name, value});
    }

    protected void logEntry(String method, String name, Object lower, Object upper) {
        LOGGER.debug("ENTERING {}( propertyName=[{}] , lowerValue=[{}], upperValue=[{}] )", new Object[]{method, name, lower, upper});
    }

    public static enum GeospatialDistanceFilterOptions {
        WITHIN,
        BEYOND;

    }

    public static enum GeospatialFilterOptions {
        CONTAINS,
        CROSSES,
        DISJOINT,
        INTERSECTS,
        WITHIN,
        TOUCHES,
        OVERLAPS,
        BBOX;

    }

    public static enum StringFilterOptions {
        CASE_SENSITIVE,
        FUZZY;

    }

    public static enum SupportedGeosOptions {
        BBOX_ONLY,
        POINT_RADUIS_AND_BBOX,
        GEOMETRY_ONLY,
        ALL;

    }
}

