/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.libs.result.relevance;

import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.codehaus.stax2.XMLInputFactory2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextParser.class);
    private static XMLInputFactory xmlInputFactory = null;

    private TextParser() {
    }

    protected static String parseTextFrom(String xmlData) {
        StringBuilder builder = new StringBuilder();
        try {
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(new StringReader(xmlData));
            while (xmlStreamReader.hasNext()) {
                String text;
                int event = xmlStreamReader.next();
                if ((event == 4 || event == 12) && StringUtils.isNotBlank((String)(text = xmlStreamReader.getText()))) {
                    builder.append(" " + text.trim());
                }
                if (event != 1) continue;
                for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    String text2 = xmlStreamReader.getAttributeValue(i);
                    if (!StringUtils.isNotBlank((String)text2)) continue;
                    builder.append(" " + text2.trim());
                }
            }
        }
        catch (XMLStreamException e1) {
            LOGGER.warn("Failure occurred in parsing the xml data (" + xmlData + "). No data has been stored or indexed.", (Throwable)e1);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(TextParser.class.getClassLoader());
            xmlInputFactory = XMLInputFactory2.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            xmlInputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

