/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.libs.cache.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import net.di2e.ecdr.api.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCache<T>
implements Cache<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryCache.class);
    private LRUCacheMap<String, T> metacardCache = null;

    public MemoryCache(int size) {
        this.metacardCache = new LRUCacheMap(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String id, T entry) {
        LOGGER.debug("Adding entry to cache with id [{}]", (Object)id);
        LRUCacheMap<String, T> lRUCacheMap = this.metacardCache;
        synchronized (lRUCacheMap) {
            this.metacardCache.put(id, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LRUCacheMap<String, T> lRUCacheMap = this.metacardCache;
        synchronized (lRUCacheMap) {
            this.metacardCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String id) {
        LOGGER.debug("Searching cache for entry with id [{}]", (Object)id);
        LRUCacheMap<String, T> lRUCacheMap = this.metacardCache;
        synchronized (lRUCacheMap) {
            return (T)this.metacardCache.get(id);
        }
    }

    public boolean containsKey(String key) {
        return this.metacardCache.containsKey(key);
    }

    public void updateCacheSize(int size) {
        this.metacardCache.updateCacheSize(size);
    }

    public class LRUCacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int cacheSize;

        public LRUCacheMap(int capacity) {
            super(capacity + 1, 1.1f, true);
            this.cacheSize = 0;
            this.cacheSize = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cacheSize;
        }

        @Override
        public V put(K k, V v) {
            if (this.cacheSize > 0) {
                return super.put(k, v);
            }
            return null;
        }

        public void updateCacheSize(int size) {
            this.clear();
            this.cacheSize = size;
        }
    }
}

