/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.libs.cache.impl;

import net.di2e.ecdr.libs.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCache<T>
implements Cache<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JCache.class);
    private javax.cache.Cache<String, T> cache = null;

    @Override
    public void put(String id, T entry) {
        LOGGER.debug("Adding entry to cache with id [{}]", (Object)id);
        this.cache.put((Object)id, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(String id) {
        LOGGER.debug("Searching cache for Entry with id [{}]", (Object)id);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JCache.class.getClassLoader());
            Object object = this.cache.get((Object)id);
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public void destroy() {
        this.cache.clear();
        this.cache.close();
    }

    public JCache(javax.cache.Cache<String, T> jcache) {
        this.cache = jcache;
    }
}

