/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.federation;

import ddf.catalog.data.Result;
import ddf.catalog.operation.Query;
import ddf.catalog.operation.SourceResponse;
import ddf.catalog.operation.impl.ProcessingDetailsImpl;
import ddf.catalog.operation.impl.QueryResponseImpl;
import ddf.catalog.plugin.PostFederatedQueryPlugin;
import ddf.catalog.plugin.PreFederatedQueryPlugin;
import ddf.catalog.source.Source;
import ddf.catalog.util.impl.DistanceResultComparator;
import ddf.catalog.util.impl.RelevanceResultComparator;
import ddf.catalog.util.impl.TemporalResultComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.di2e.ecdr.federation.AbstractFederationStrategy;
import net.di2e.ecdr.libs.result.relevance.RelevanceNormalizer;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;

public class NormalizingSortedFederationStrategy
extends AbstractFederationStrategy {
    protected static final Comparator<Result> DEFAULT_COMPARATOR = new RelevanceResultComparator(SortOrder.DESCENDING);
    private static final XLogger LOGGER = new XLogger(LoggerFactory.getLogger(NormalizingSortedFederationStrategy.class));
    private boolean normalizeResults = true;
    private RelevanceNormalizer relevanceNormalizer = null;

    public NormalizingSortedFederationStrategy(ExecutorService queryExecutorService, List<PreFederatedQueryPlugin> preQuery, List<PostFederatedQueryPlugin> postQuery, RelevanceNormalizer normalizer) {
        super(queryExecutorService, preQuery, postQuery);
        this.relevanceNormalizer = normalizer;
    }

    @Override
    protected Runnable createMonitor(ExecutorService pool, Map<Source, Future<SourceResponse>> futures, QueryResponseImpl returnResults, Query query) {
        return new SortedQueryMonitor(pool, futures, returnResults, query);
    }

    @Override
    public void setNormalizeResults(boolean normalize) {
        LOGGER.debug("Setting the normalizeResults flag to {}", (Object)normalize);
        this.normalizeResults = normalize;
    }

    private class SortedQueryMonitor
    implements Runnable {
        private QueryResponseImpl returnResults;
        private Map<Source, Future<SourceResponse>> futures;
        private Query query;

        public SortedQueryMonitor(ExecutorService pool, Map<Source, Future<SourceResponse>> futuress, QueryResponseImpl returnResults, Query query) {
            this.returnResults = returnResults;
            this.query = query;
            this.futures = futuress;
        }

        @Override
        public void run() {
            String methodName = "run";
            LOGGER.entry(new Object[]{methodName});
            SortBy sortBy = this.query.getSortBy();
            TemporalResultComparator coreComparator = DEFAULT_COMPARATOR;
            if (sortBy != null && sortBy.getPropertyName() != null) {
                PropertyName sortingProp = sortBy.getPropertyName();
                String sortType = sortingProp.getPropertyName();
                SortOrder sortOrder = sortBy.getSortOrder() == null ? SortOrder.DESCENDING : sortBy.getSortOrder();
                LOGGER.debug("Sorting by type: " + sortType);
                LOGGER.debug("Sorting by Order: " + sortBy.getSortOrder());
                if ("effective".equals(sortType) || "modified".equals(sortType) || "created".equals(sortType)) {
                    coreComparator = new TemporalResultComparator(sortOrder, sortType);
                } else if ("TEMPORAL".equals(sortType)) {
                    coreComparator = new TemporalResultComparator(sortOrder);
                } else if ("DISTANCE".equals(sortType)) {
                    coreComparator = new DistanceResultComparator(sortOrder);
                } else if ("RELEVANCE".equals(sortType)) {
                    coreComparator = new RelevanceResultComparator(sortOrder);
                }
            }
            List resultList = new ArrayList();
            long totalHits = 0L;
            Set processingDetails = this.returnResults.getProcessingDetails();
            long deadline = System.currentTimeMillis() + this.query.getTimeoutMillis();
            Map returnProperties = this.returnResults.getProperties();
            for (Map.Entry<Source, Future<SourceResponse>> entry : this.futures.entrySet()) {
                Source site = entry.getKey();
                SourceResponse sourceResponse = null;
                try {
                    sourceResponse = this.query.getTimeoutMillis() < 1L ? entry.getValue().get() : entry.getValue().get(this.getTimeRemaining(deadline), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Couldn't get results from completed federated query on site with ShortName " + site.getId(), (Throwable)e);
                    processingDetails.add(new ProcessingDetailsImpl(site.getId(), (Exception)e));
                }
                catch (ExecutionException e) {
                    LOGGER.warn("Couldn't get results from completed federated query on site " + site.getId(), (Throwable)e);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Adding exception to response.");
                    }
                    processingDetails.add(new ProcessingDetailsImpl(site.getId(), (Exception)e));
                }
                catch (TimeoutException e) {
                    LOGGER.warn("search timed out: " + new Date() + " on site " + site.getId());
                    processingDetails.add(new ProcessingDetailsImpl(site.getId(), (Exception)e));
                }
                if (sourceResponse == null) continue;
                List sourceResults = sourceResponse.getResults();
                resultList.addAll(sourceResults);
                long sourceHits = sourceResponse.getHits();
                totalHits += sourceHits;
                HashMap<String, Number> newSourceProperties = new HashMap<String, Number>();
                newSourceProperties.put("total-hits", sourceHits);
                newSourceProperties.put("total-results-returned", sourceResults.size());
                Map originalSourceProperties = sourceResponse.getProperties();
                if (originalSourceProperties != null) {
                    Serializable object = (Serializable)originalSourceProperties.get("elapsed-time");
                    if (object != null && object instanceof Long) {
                        newSourceProperties.put("elapsed-time", (Long)object);
                        originalSourceProperties.remove("elapsed-time");
                        LOGGER.debug("Setting the elapsedTime responseProperty to {} for source {}", (Object)object, (Object)site.getId());
                    }
                    returnProperties.putAll(originalSourceProperties);
                }
                returnProperties.put(site.getId(), (Serializable)newSourceProperties);
                LOGGER.debug("Setting the query responseProperties for site {}", (Object)site.getId());
                ArrayList siteListObject = (ArrayList)returnProperties.get("site-list");
                if (siteListObject != null && siteListObject instanceof List) {
                    ((List)siteListObject).add(site.getId());
                    continue;
                }
                siteListObject = new ArrayList();
                ((List)siteListObject).add(site.getId());
                returnProperties.put("site-list", siteListObject);
            }
            LOGGER.debug("all sites finished returning results: " + resultList.size());
            if (NormalizingSortedFederationStrategy.this.normalizeResults) {
                resultList = NormalizingSortedFederationStrategy.this.relevanceNormalizer.normalize(resultList, this.query);
            }
            LOGGER.debug("Sorting the results by {}", (Object)coreComparator);
            Collections.sort(resultList, coreComparator);
            this.returnResults.setHits(totalHits);
            int maxResults = this.query.getPageSize() > 0 ? this.query.getPageSize() : Integer.MAX_VALUE;
            this.returnResults.addResults(resultList.size() > maxResults ? resultList.subList(0, maxResults) : resultList, true);
        }

        private long getTimeRemaining(long deadline) {
            long timeleft = System.currentTimeMillis() > deadline ? 0L : deadline - System.currentTimeMillis();
            return timeleft;
        }
    }
}

