/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.endpoint.rest;

import ddf.catalog.CatalogFramework;
import ddf.catalog.federation.FederationException;
import ddf.catalog.federation.FederationStrategy;
import ddf.catalog.operation.Query;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.operation.impl.QueryRequestImpl;
import ddf.catalog.source.SourceUnavailableException;
import ddf.catalog.source.UnsupportedQueryException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.di2e.ecdr.api.auditor.SearchAuditor;
import net.di2e.ecdr.api.cache.QueryRequestCache;
import net.di2e.ecdr.api.query.QueryConfiguration;
import net.di2e.ecdr.api.query.QueryLanguage;
import net.di2e.ecdr.api.transform.TransformIdMapper;
import net.di2e.ecdr.commons.endpoint.rest.AbstractRestSearchEndpoint;
import net.di2e.ecdr.commons.query.CDRQueryImpl;
import net.di2e.ecdr.commons.xml.fs.SourceDescription;
import net.di2e.ecdr.commons.xml.osd.OpenSearchDescription;
import net.di2e.ecdr.federation.FifoFederationStrategy;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class CDRRestSearchServiceImpl
extends AbstractRestSearchEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDRRestSearchServiceImpl.class);
    private static final String RELATIVE_URL = "/services/cdr/search/rest";
    private static final String SERVICE_TYPE = "CDR REST Search Service";
    private FifoFederationStrategy fifoFederationStratgey = null;
    private static final Map<String, String> REGISTRABLE_PROPERTIES = new HashMap<String, String>();

    public CDRRestSearchServiceImpl(CatalogFramework framework, ConfigurationWatcherImpl config, List<QueryLanguage> queryLangs, TransformIdMapper mapper, List<SearchAuditor> auditorList, QueryConfiguration queryConfig, QueryRequestCache queryCache, FifoFederationStrategy fedStrategy) {
        super(framework, config, queryLangs, mapper, auditorList, queryConfig, queryCache);
        this.fifoFederationStratgey = fedStrategy;
    }

    @HEAD
    public Response ping(@Context UriInfo uriInfo, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        Response response = this.executePing(uriInfo, encoding, auth);
        LOGGER.debug("Ping (HTTP HEAD) was called to check if the CDR Search Endpoint is available, result is [{}]", (Object)response.getStatus());
        return response;
    }

    @GET
    public Response search(@Context MessageContext context, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        UriInfo uriInfo = context.getUriInfo();
        LOGGER.debug("Query received on CDR Search Endpoint: {}", (Object)uriInfo.getRequestUri());
        return this.executeSearch(context.getHttpServletRequest(), uriInfo, encoding, auth);
    }

    public String getServiceType() {
        return SERVICE_TYPE;
    }

    public String getServiceRelativeUrl() {
        return RELATIVE_URL;
    }

    public String getServiceDescription() {
        return "Provides a RESTful search service using the CDR Search specification.";
    }

    public Map<String, String> getProperties() {
        return REGISTRABLE_PROPERTIES;
    }

    protected void addSourceDescriptions(OpenSearchDescription osd) {
        String curSource = this.getCatalogFramework().getId();
        SourceDescription description = new SourceDescription();
        description.setSourceId(curSource);
        description.setShortName(curSource);
        osd.getAny().add(description);
    }

    public QueryResponse executeQuery(String localSourceId, MultivaluedMap<String, String> queryParameters, CDRQueryImpl query) throws SourceUnavailableException, UnsupportedQueryException, FederationException {
        QueryRequestImpl queryRequest = new QueryRequestImpl((Query)query, false, Arrays.asList(localSourceId), this.getQueryProperties(queryParameters, localSourceId));
        QueryResponse queryResponse = this.getCatalogFramework().query((QueryRequest)queryRequest, (FederationStrategy)this.fifoFederationStratgey);
        return queryResponse;
    }

    static {
        REGISTRABLE_PROPERTIES.put("receiveTimeoutSeconds", "0");
        REGISTRABLE_PROPERTIES.put("connectionTimeoutSeconds", "30");
        REGISTRABLE_PROPERTIES.put("maxResultCount", "0");
        REGISTRABLE_PROPERTIES.put("doSourcePing", "true");
        REGISTRABLE_PROPERTIES.put("availableCheckCacheTime", "60");
    }
}

