/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.endpoint.rest;

import ddf.catalog.CatalogFramework;
import ddf.catalog.federation.FederationException;
import ddf.catalog.federation.FederationStrategy;
import ddf.catalog.filter.FilterBuilder;
import ddf.catalog.operation.Query;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.operation.impl.QueryRequestImpl;
import ddf.catalog.source.SourceUnavailableException;
import ddf.catalog.source.UnsupportedQueryException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.di2e.ecdr.api.auditor.SearchAuditor;
import net.di2e.ecdr.commons.endpoint.rest.AbstractRestSearchEndpoint;
import net.di2e.ecdr.commons.query.rest.CDRQueryImpl;
import net.di2e.ecdr.commons.query.rest.parsers.QueryParser;
import net.di2e.ecdr.federation.FifoFederationStrategy;
import net.di2e.ecdr.search.transform.mapper.TransformIdMapper;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class CDRRestSearchServiceImpl
extends AbstractRestSearchEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDRRestSearchServiceImpl.class);
    private static final String RELATIVE_URL = "/services/cdr/search/rest";
    private static final String SERVICE_TYPE = "CDR REST Search Service";
    private FifoFederationStrategy fifoFederationStratgey = null;
    private static final Map<String, String> REGISTRABLE_PROPERTIES = new HashMap<String, String>();

    public CDRRestSearchServiceImpl(CatalogFramework framework, ConfigurationWatcherImpl config, FilterBuilder builder, QueryParser parser, TransformIdMapper mapper, FifoFederationStrategy fedStrategy, List<SearchAuditor> auditors) {
        super(framework, config, builder, parser, mapper, auditors);
        this.fifoFederationStratgey = fedStrategy;
    }

    @HEAD
    public Response ping(@Context UriInfo uriInfo, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        Response response = this.executePing(uriInfo, encoding, auth);
        LOGGER.debug("Ping (HTTP HEAD) was called to check if the CDR Search Endpoint is available, result is [{}]", (Object)response.getStatus());
        return response;
    }

    @GET
    public Response search(@Context MessageContext context, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        UriInfo uriInfo = context.getUriInfo();
        LOGGER.debug("Query received on CDR Search Endpoint: {}", (Object)uriInfo.getRequestUri());
        return this.executeSearch(context.getHttpServletRequest(), uriInfo, encoding, auth);
    }

    public String getParameterTemplate() {
        return "?q={os:searchTerms}&caseSensitive={caseSensitive?}&fuzzy={fuzzy?}&timeout={fs:maxTimeout?}&start={os:startIndex?}&uid={uid?}&strictMode={strictMode?}&dtstart={time:start?}&dtend={time:end?}&dtType={time:type?}&collections={ecdr:collections?}&sort={fs:sort?}&box={geo:box?}&lat={geo:lat?}&lon={geo:lon?}&radius={geo:radius?}&geometry={geo:geometry?}&polygon={polygon?}&count={os:count?}&sortKeys={sru:sortKeys?}&status={cdrb:includeStatus?}&format={cdrs:responseFormat?}&timeout={cdrb:timeout?}&queryLanguage={queryLanguage?}&oid={oid?}";
    }

    public String getServiceType() {
        return SERVICE_TYPE;
    }

    public String getServiceRelativeUrl() {
        return RELATIVE_URL;
    }

    public String getServiceDescription() {
        return "Provides a RESTful search service using the CDR Search specification.";
    }

    public Map<String, String> getProperties() {
        return REGISTRABLE_PROPERTIES;
    }

    public boolean useDefaultSortIfNotSpecified() {
        return true;
    }

    public QueryResponse executeQuery(String localSourceId, MultivaluedMap<String, String> queryParameters, CDRQueryImpl query) throws SourceUnavailableException, UnsupportedQueryException, FederationException {
        QueryRequestImpl queryRequest = new QueryRequestImpl((Query)query, false, query.getSiteNames(), this.getQueryParser().getQueryProperties(queryParameters, localSourceId));
        QueryResponse queryResponse = this.getCatalogFramework().query((QueryRequest)queryRequest, (FederationStrategy)this.fifoFederationStratgey);
        return queryResponse;
    }

    static {
        REGISTRABLE_PROPERTIES.put("receiveTimeoutSeconds", "0");
        REGISTRABLE_PROPERTIES.put("connectionTimeoutSeconds", "30");
        REGISTRABLE_PROPERTIES.put("maxResultCount", "0");
        REGISTRABLE_PROPERTIES.put("doSourcePing", "true");
        REGISTRABLE_PROPERTIES.put("availableCheckCacheTime", "60");
    }
}

