/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.endpoint.rest;

import ddf.catalog.CatalogFramework;
import ddf.catalog.federation.FederationException;
import ddf.catalog.filter.FilterBuilder;
import ddf.catalog.operation.Query;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.operation.impl.QueryRequestImpl;
import ddf.catalog.source.SourceUnavailableException;
import ddf.catalog.source.UnsupportedQueryException;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.di2e.ecdr.commons.endpoint.rest.AbstractRestSearchEndpoint;
import net.di2e.ecdr.commons.query.rest.CDRQueryImpl;
import net.di2e.ecdr.commons.query.rest.parsers.QueryParser;
import net.di2e.ecdr.search.transform.mapper.TransformIdMapper;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class CDRRestSearchServiceImpl
extends AbstractRestSearchEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDRRestSearchServiceImpl.class);
    private static final String RELATIVE_URL = "/services/cdr/search/rest";
    private static final String SERVICE_TYPE = "CDR REST Search Service";

    public CDRRestSearchServiceImpl(CatalogFramework framework, ConfigurationWatcherImpl config, FilterBuilder builder, QueryParser parser, TransformIdMapper mapper) {
        super(framework, config, builder, parser, mapper);
    }

    @HEAD
    public Response ping(@Context UriInfo uriInfo, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        Response response = this.executePing(uriInfo, encoding, auth);
        LOGGER.debug("Ping (HTTP HEAD) was called to check if the CDR Search Endpoint is available, result is [{}]", (Object)response.getStatus());
        return response;
    }

    @GET
    public Response search(@Context UriInfo uriInfo, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        LOGGER.debug("Query received on CDR Search Endpoint: {}", (Object)uriInfo.getRequestUri());
        return this.executeSearch(uriInfo, encoding, auth);
    }

    public String getServiceType() {
        return SERVICE_TYPE;
    }

    public String getServiceRelativeUrl() {
        return RELATIVE_URL;
    }

    public String getServiceDescription() {
        return "Provides a RESTful search service using the CDR Search specification.";
    }

    public boolean useDefaultSortIfNotSpecified() {
        return true;
    }

    public QueryResponse executeQuery(String localSourceId, MultivaluedMap<String, String> queryParameters, CDRQueryImpl query) throws SourceUnavailableException, UnsupportedQueryException, FederationException {
        QueryRequestImpl queryRequest = new QueryRequestImpl((Query)query, false, query.getSiteNames(), this.getQueryParser().getQueryProperties(queryParameters, localSourceId));
        QueryResponse queryResponse = this.getCatalogFramework().query((QueryRequest)queryRequest);
        return queryResponse;
    }
}

