/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.describe.publisher;

import ddf.catalog.CatalogFramework;
import ddf.catalog.data.Metacard;
import ddf.catalog.operation.CreateRequest;
import ddf.catalog.operation.CreateResponse;
import ddf.catalog.operation.impl.CreateRequestImpl;
import ddf.catalog.source.IngestException;
import ddf.catalog.source.SourceUnavailableException;
import ddf.security.Subject;
import java.util.Arrays;
import java.util.Collection;
import org.apache.shiro.util.ThreadContext;
import org.codice.ddf.security.common.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescribePublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DescribePublisher.class);
    private CatalogFramework framework = null;

    public DescribePublisher(CatalogFramework fw) {
        this.framework = fw;
    }

    public void publish(Collection<Metacard> describeMetacards) {
        ThreadContext.bind((org.apache.shiro.subject.Subject)this.getSystemSubject());
        CreateRequestImpl create = new CreateRequestImpl(Arrays.asList(describeMetacards.toArray(new Metacard[describeMetacards.size()])), null);
        try {
            CreateResponse response = this.framework.create((CreateRequest)create);
            LOGGER.debug("Published {} describe metacards successfully with tag 'describe'", (Object)response.getCreatedMetacards().size());
        }
        catch (IngestException | SourceUnavailableException e) {
            LOGGER.error("Publishing describe records to catalog failed", e);
        }
    }

    protected Subject getSystemSubject() {
        return (Subject)Security.runAsAdmin(() -> Security.getInstance().getSystemSubject());
    }
}

