/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.describe.endpoint.rest;

import ddf.registry.api.RegistrableService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class CDRRestDescribeService
implements RegistrableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDRRestDescribeService.class);
    private static final String RELATIVE_URL = "/services/cdr/describe/rest";
    private static final String SERVICE_TYPE = "CDR REST Describe Service";
    private String pathToDescribeFile = null;

    @HEAD
    public Response ping() {
        LOGGER.debug("Ping (HTTP HEAD) was called to check if the CDR Describe Endpoint");
        boolean isAvailable = false;
        if (StringUtils.isNotBlank((String)this.pathToDescribeFile) && new File(this.pathToDescribeFile).exists()) {
            isAvailable = true;
        }
        return isAvailable ? Response.ok().build() : Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"application/json", "application/xml", "text/xml"})
    public Response describe() {
        LOGGER.debug("Describe request sent, returning the description that is located at {}", (Object)this.pathToDescribeFile);
        if (StringUtils.isNotBlank((String)this.pathToDescribeFile)) {
            try (FileInputStream fis = new FileInputStream(this.pathToDescribeFile);){
                String xml = IOUtils.toString((InputStream)fis);
                Response response = Response.ok((Object)xml, (MediaType)new MediaType("application", "xml")).build();
                return response;
            }
            catch (IOException e) {
                LOGGER.warn("The describe service could not read the file located at {} because encountered error {}", new Object[]{this.pathToDescribeFile, e.getMessage(), e});
            }
        }
        LOGGER.warn("The describe service could not read the file located at {}, returning Internal Server Error Status {}", (Object)this.pathToDescribeFile, (Object)Response.Status.INTERNAL_SERVER_ERROR);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    public String getServiceType() {
        return SERVICE_TYPE;
    }

    public String getServiceRelativeUrl() {
        return RELATIVE_URL;
    }

    public String getServiceDescription() {
        return "Describes the Content Collections available through the CDR Search and Brokered interfaces";
    }

    public Map<String, String> getProperties() {
        return Collections.EMPTY_MAP;
    }

    public void setPathToDescribeFile(String fileLocation) {
        this.pathToDescribeFile = fileLocation;
    }
}

