/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.describe.commands;

import ddf.catalog.CatalogFramework;
import ddf.catalog.data.Metacard;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import net.di2e.ecdr.describe.commands.GenerateDescribeCompleter;
import net.di2e.ecdr.describe.generator.DescribeGenerator;
import net.di2e.ecdr.describe.publisher.DescribePublisher;
import org.apache.commons.collections.CollectionUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="cdr", name="describe", description="Generates describe records for one more more local/remote Sources. If no options are selected it will cycle through all Sources and write the files to the describe directory")
@Service
public class GenerateDescribeCommand
implements Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateDescribeCommand.class);
    static final String DESCRIBE_DIR = "describe";
    @Argument(index=0, name="sourceIds", description="The name of the Source/Site to generate the Describe Record for", required=false, multiValued=true)
    @Completion(value=GenerateDescribeCompleter.class)
    private List<String> ids;
    @Option(name="--publish", description="publish the describe metadata to the local catalog with the tag 'describe'")
    private boolean publishDescribe = false;
    @Option(name="--nowrite", description="Do not write the output of the describe file to disk.  By default they are written to $DDF_HOME/describe directory")
    private boolean doNotWrite = false;
    @Option(name="--print", description="Print the describe records to the screen")
    private boolean print = false;
    @Reference
    private CatalogFramework framework;
    @Reference
    private DescribeGenerator describeGenerator;
    private PrintStream console = System.out;

    public GenerateDescribeCommand() {
        FileUtils.mkDir((File)new File(DESCRIBE_DIR));
    }

    public Object execute() throws Exception {
        try {
            HashMap<String, Metacard> describeRecords = new HashMap<String, Metacard>();
            if (CollectionUtils.isNotEmpty(this.ids)) {
                this.ids.forEach(sourceId -> {
                    this.console.println("Generating Describe record for " + sourceId);
                    Metacard card = this.describeGenerator.generate((String)sourceId);
                    describeRecords.put((String)sourceId, card);
                });
            } else {
                this.framework.getSourceIds().forEach(sourceId -> {
                    this.console.println("Generating Describe record for " + sourceId);
                    Metacard card = this.describeGenerator.generate((String)sourceId);
                    describeRecords.put((String)sourceId, card);
                });
            }
            if (!this.doNotWrite) {
                describeRecords.forEach((id, card) -> this.writeToFile((String)id, card.getMetadata()));
            }
            if (this.publishDescribe) {
                DescribePublisher publisher = new DescribePublisher(this.framework);
                publisher.publish(describeRecords.values());
                this.console.println("Succesfully published " + describeRecords.size() + " describe records to catalog.");
            }
            if (this.print) {
                describeRecords.forEach((id, card) -> {
                    this.console.println("------------------- " + id + " -------------------");
                    this.console.println(card.getMetadata());
                    this.console.println("---------------------------------------------------------");
                });
            }
        }
        catch (Exception e) {
            this.console.println("Encountered error while trying to perform command. Check log for more details.");
            LOGGER.warn("Error while performing command.", (Throwable)e);
        }
        return null;
    }

    protected void writeToFile(String sourceId, String xml) {
        try {
            String filename = sourceId + "-describe-" + System.currentTimeMillis() / 1000L + ".xml";
            Files.write(Paths.get(DESCRIBE_DIR, filename), xml.getBytes(), StandardOpenOption.CREATE);
            this.console.println("New describe file written to DDF_HOME/describe: " + filename);
        }
        catch (IOException e) {
            LOGGER.error("Could not write describe file for source {}", (Object)sourceId, (Object)e);
        }
    }
}

