/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.broker.endpoint.rest;

import ddf.catalog.CatalogFramework;
import ddf.catalog.federation.FederationException;
import ddf.catalog.federation.FederationStrategy;
import ddf.catalog.operation.Query;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.operation.impl.QueryRequestImpl;
import ddf.catalog.source.SourceUnavailableException;
import ddf.catalog.source.UnsupportedQueryException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.di2e.ecdr.api.auditor.SearchAuditor;
import net.di2e.ecdr.api.cache.QueryRequestCache;
import net.di2e.ecdr.api.federation.NormalizingFederationStrategy;
import net.di2e.ecdr.api.query.QueryConfiguration;
import net.di2e.ecdr.api.query.QueryLanguage;
import net.di2e.ecdr.api.transform.TransformIdMapper;
import net.di2e.ecdr.commons.endpoint.rest.AbstractRestSearchEndpoint;
import net.di2e.ecdr.commons.query.CDRQueryImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.opengis.filter.sort.SortBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class CDRRestBrokerServiceImpl
extends AbstractRestSearchEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDRRestBrokerServiceImpl.class);
    private static final String RELATIVE_URL = "/services/cdr/broker/rest";
    private static final String SERVICE_TYPE = "CDR REST Brokered Search Service";
    private NormalizingFederationStrategy sortedFedStrategy = null;
    private FederationStrategy defaultFederationStrategy = null;

    public CDRRestBrokerServiceImpl(CatalogFramework framework, ConfigurationWatcherImpl config, List<QueryLanguage> queryLangs, TransformIdMapper mapper, List<SearchAuditor> auditorList, QueryConfiguration queryConfig, QueryRequestCache queryCache, NormalizingFederationStrategy sortedFedStrategy, FederationStrategy defaultFedStrategy) {
        super(framework, config, queryLangs, mapper, auditorList, queryConfig, queryCache);
        this.sortedFedStrategy = sortedFedStrategy;
        this.defaultFederationStrategy = defaultFedStrategy;
    }

    @HEAD
    public Response ping(@Context UriInfo uriInfo, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        Response response = this.executePing(uriInfo, encoding, auth);
        LOGGER.debug("Ping (HTTP HEAD) was called to check if the CDR Broker Endpoint is available, result is [{}]", (Object)response.getStatus());
        return response;
    }

    @GET
    public Response search(@Context MessageContext context, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        UriInfo uriInfo = context.getUriInfo();
        LOGGER.debug("Query received on CDR Broker Endpoint: {}", (Object)uriInfo.getRequestUri());
        return this.executeSearch(context.getHttpServletRequest(), uriInfo, encoding, auth);
    }

    public String getServiceType() {
        return SERVICE_TYPE;
    }

    public String getServiceRelativeUrl() {
        return RELATIVE_URL;
    }

    public String getServiceDescription() {
        return "Provides a RESTful search service using the CDR Brokered Search specification.";
    }

    public String getParameterTemplate(String queryLanguageName) {
        return super.getParameterTemplate(queryLanguageName) + "&source={cdrb:routeTo?}";
    }

    public QueryResponse executeQuery(String localSourceId, MultivaluedMap<String, String> queryParameters, CDRQueryImpl query) throws SourceUnavailableException, UnsupportedQueryException, FederationException {
        Collection siteNames = query.getSiteNames();
        QueryRequestImpl queryRequest = new QueryRequestImpl((Query)query, siteNames.isEmpty(), siteNames, this.getQueryProperties(queryParameters, localSourceId));
        SortBy originalSortBy = query.getSortBy();
        QueryResponse queryResponse = originalSortBy == null ? this.getCatalogFramework().query((QueryRequest)queryRequest, this.defaultFederationStrategy) : this.getCatalogFramework().query((QueryRequest)queryRequest, (FederationStrategy)this.sortedFedStrategy);
        return queryResponse;
    }

    protected String replaceTemplateValues(String osdTemplate) {
        String additionalParams = "cdrb:routeTo - a comma separated lists of siteNames (sources) that the query should be federated to " + System.lineSeparator() + "            default: [sent to all sites]" + System.lineSeparator() + "            allowedValues: " + this.getAllSites() + System.lineSeparator() + "            localSourceId: " + this.getCatalogFramework().getId() + System.lineSeparator() + "            example: site1,site2";
        osdTemplate = StringUtils.replace((String)osdTemplate, (String)"${additionalBasicParameters}", (String)additionalParams, (int)1);
        return super.replaceTemplateValues(osdTemplate);
    }

    private String getAllSites() {
        StringBuilder builder = new StringBuilder();
        Set ids = this.getCatalogFramework().getSourceIds();
        for (String id : ids) {
            builder.append("'" + id + "' ");
        }
        return builder.toString().trim();
    }
}

