/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.broker.endpoint.rest;

import ddf.catalog.CatalogFramework;
import ddf.catalog.federation.FederationException;
import ddf.catalog.federation.FederationStrategy;
import ddf.catalog.filter.FilterBuilder;
import ddf.catalog.operation.Query;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.operation.impl.QueryRequestImpl;
import ddf.catalog.source.SourceUnavailableException;
import ddf.catalog.source.UnsupportedQueryException;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.di2e.ecdr.commons.endpoint.rest.AbstractRestSearchEndpoint;
import net.di2e.ecdr.commons.query.rest.CDRQueryImpl;
import net.di2e.ecdr.commons.query.rest.parsers.QueryParser;
import net.di2e.ecdr.federation.api.NormalizingFederationStrategy;
import net.di2e.ecdr.search.transform.mapper.TransformIdMapper;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.opengis.filter.sort.SortBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class CDRRestBrokerServiceImpl
extends AbstractRestSearchEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDRRestBrokerServiceImpl.class);
    private static final String RELATIVE_URL = "/services/cdr/broker/rest";
    private static final String SERVICE_TYPE = "CDR Brokered REST Search";
    private NormalizingFederationStrategy sortedFedStrategy = null;
    private FederationStrategy defaultFederationStrategy = null;

    public CDRRestBrokerServiceImpl(CatalogFramework framework, ConfigurationWatcherImpl config, FilterBuilder builder, QueryParser parser, TransformIdMapper mapper, NormalizingFederationStrategy sortedFedStrategy, FederationStrategy defaultFedStrategy) {
        super(framework, config, builder, parser, mapper);
        this.sortedFedStrategy = sortedFedStrategy;
        this.defaultFederationStrategy = defaultFedStrategy;
    }

    @HEAD
    public Response ping(@Context UriInfo uriInfo, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        Response response = this.executePing(uriInfo, encoding, auth);
        LOGGER.debug("Ping (HTTP HEAD) was called to check if the CDR Broker Endpoint is available, result is [{}]", (Object)response.getStatus());
        return response;
    }

    @GET
    public Response search(@Context UriInfo uriInfo, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        LOGGER.debug("Query received on CDR Broker Endpoint: {}", (Object)uriInfo.getRequestUri());
        return this.executeSearch(uriInfo, encoding, auth);
    }

    public String getServiceType() {
        return SERVICE_TYPE;
    }

    public String getServiceRelativeUrl() {
        return RELATIVE_URL;
    }

    public String getServiceDescription() {
        return "Provides a RESTful search service using the CDR Brokered Search specification.";
    }

    public String getParameterTemplate() {
        return "?q={os:searchTerms}&src={fs:routeTo?}&caseSensitive={caseSensitive?}&fuzzy={fuzzy?}&timeout={fs:maxTimeout?}&start={os:startIndex?}&uid={uid?}&strictMode={strictMode?}&dtstart={time:start?}&dtend={time:end?}&dtType={time:type?}&filter={fs:sourceFilter?}&sort={fs:sort?}&box={geo:box?}&lat={geo:lat?}&lon={geo:lon?}&radius={geo:radius?}&geometry={geo:geometry?}&polygon={polygon?}&count={os:count?}&sortKeys={sru:sortKeys?}&status={cdrb:includeStatus?}&format={cdrs:responseFormat?}&timeout={cdrb:timeout?}&queryLanguage={queryLanguage?}&oid={oid?}";
    }

    public boolean useDefaultSortIfNotSpecified() {
        return false;
    }

    public QueryResponse executeQuery(String localSourceId, MultivaluedMap<String, String> queryParameters, CDRQueryImpl query) throws SourceUnavailableException, UnsupportedQueryException, FederationException {
        Collection siteNames = query.getSiteNames();
        QueryRequestImpl queryRequest = new QueryRequestImpl((Query)query, siteNames.isEmpty(), siteNames, this.getQueryParser().getQueryProperties(queryParameters, localSourceId));
        SortBy originalSortBy = this.getQueryParser().getSortBy(queryParameters);
        QueryResponse queryResponse = originalSortBy == null ? this.getCatalogFramework().query((QueryRequest)queryRequest, this.defaultFederationStrategy) : this.getCatalogFramework().query((QueryRequest)queryRequest, (FederationStrategy)this.sortedFedStrategy);
        return queryResponse;
    }
}

