/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.broker.endpoint.rest;

import ddf.catalog.CatalogFramework;
import ddf.catalog.data.BinaryContent;
import ddf.catalog.federation.FederationException;
import ddf.catalog.federation.FederationStrategy;
import ddf.catalog.filter.FilterBuilder;
import ddf.catalog.operation.Query;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.operation.SourceResponse;
import ddf.catalog.operation.impl.QueryRequestImpl;
import ddf.catalog.source.SourceUnavailableException;
import ddf.catalog.source.UnsupportedQueryException;
import ddf.catalog.transform.CatalogTransformerException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.di2e.ecdr.commons.query.rest.CDRQueryImpl;
import net.di2e.ecdr.commons.query.rest.parsers.QueryParser;
import net.di2e.ecdr.commons.query.util.QueryHelper;
import org.apache.cxf.jaxrs.client.WebClient;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.opengis.filter.sort.SortBy;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;

@Path(value="/")
public class CDRRestBrokerServiceImpl {
    private static final XLogger LOGGER = new XLogger(LoggerFactory.getLogger(CDRRestBrokerServiceImpl.class));
    public static final String NO_QUERY_PARAMETERS_MESSAGE = "The query did not contain any of the required critera, one of the following is required [searchTerms, geospatial, or temporal]";
    private CatalogFramework catalogFramework = null;
    private ConfigurationWatcherImpl platformConfig = null;
    private FilterBuilder filterBuilder = null;
    private QueryParser queryParser = null;
    private FederationStrategy sortedFedStrategy = null;
    private FederationStrategy fifoFedStrategy = null;

    public CDRRestBrokerServiceImpl(CatalogFramework framework, ConfigurationWatcherImpl config, FilterBuilder builder, QueryParser parser, FederationStrategy strategy, FederationStrategy fifo) {
        this.catalogFramework = framework;
        this.platformConfig = config;
        this.filterBuilder = builder;
        this.queryParser = parser;
        this.sortedFedStrategy = strategy;
        this.fifoFedStrategy = fifo;
    }

    @HEAD
    public Response ping(@Context UriInfo uriInfo, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        boolean isValid = this.queryParser.isValidQuery(uriInfo.getQueryParameters(), this.platformConfig.getSiteName());
        return isValid ? Response.ok().build() : Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    public Response search(@Context UriInfo uriInfo, @HeaderParam(value="Accept-Encoding") String encoding, @HeaderParam(value="Authorization") String auth) {
        LOGGER.debug("Query received: " + uriInfo.getRequestUri());
        Response response = null;
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        try {
            String localSourceId = this.platformConfig.getSiteName();
            CDRQueryImpl query = new CDRQueryImpl(this.filterBuilder, queryParameters, this.queryParser, false, localSourceId);
            Map queryProperties = this.queryParser.getQueryProperties(queryParameters, localSourceId);
            Collection siteNames = query.getSiteNames();
            SortBy sortBy = this.queryParser.getSortBy(queryParameters);
            QueryResponse queryResponse = this.catalogFramework.query((QueryRequest)new QueryRequestImpl((Query)query, siteNames.isEmpty(), siteNames, queryProperties), sortBy == null ? this.fifoFedStrategy : this.sortedFedStrategy);
            String format = query.getResponseFormat();
            Map transformerProperties = QueryHelper.getTransformLinkProperties((UriInfo)uriInfo, (Query)query, (QueryResponse)queryResponse, (String)this.platformConfig.getSchemeFromProtocol(), (String)this.platformConfig.getHostname(), (Integer)this.platformConfig.getPort());
            transformerProperties.put("feed-title", "Atom Search Results from '" + localSourceId + "' for Query: " + query.getHumanReadableQuery().trim());
            transformerProperties.put("format", format);
            transformerProperties.put("status", queryParameters.getFirst((Object)"status"));
            transformerProperties.put("broker-retrieve-url", uriInfo.getBaseUri() + "/retrieve?url=");
            BinaryContent content = this.catalogFramework.transform((SourceResponse)queryResponse, format.contains("ddms") ? "atom-ddms-2.0" : format, transformerProperties);
            response = Response.ok((Object)content.getInputStream(), (String)content.getMimeTypeValue()).build();
        }
        catch (UnsupportedQueryException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (SourceUnavailableException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (FederationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (CatalogTransformerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return response;
    }

    @GET
    @Path(value="/retrieve")
    public Response retrieve(@QueryParam(value="url") String remoteURL) throws UnsupportedEncodingException {
        String url = URLDecoder.decode(remoteURL, "UTF-8");
        WebClient client = WebClient.create((String)url);
        return client.get();
    }
}

