/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.endpoint.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.opengis.filter.sort.SortOrder;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSortTypeConfigurations {
    private static final String MAPPING_PID = "ecdr-sort-mapping";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSortTypeConfigurations.class);
    private ConfigurationAdmin configAdmin;
    private List<Configuration> configurationList = new ArrayList<Configuration>();

    public DefaultSortTypeConfigurations(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    public void init() throws IOException {
        for (SortMap map : SortMap.values()) {
            LOGGER.debug("Adding configuration with key {}", (Object)map.getKey());
            Configuration configuration = this.configAdmin.createFactoryConfiguration(MAPPING_PID);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("sortKey", map.getKey());
            ((Dictionary)properties).put("sortAttribute", map.getAttribute());
            ((Dictionary)properties).put("sortOrder", map.getOrder());
            configuration.update(properties);
            this.configurationList.add(configuration);
        }
    }

    public void destroy() throws IOException {
        for (Configuration curConfig : this.configurationList) {
            curConfig.delete();
        }
    }

    public static enum SortMap {
        TITLE("entry/title", "title", SortOrder.ASCENDING.name()),
        MODIFIED_DATE("entry/date", "modified", SortOrder.DESCENDING.name()),
        EFFECTIVE_DATE("effective", "effective", SortOrder.DESCENDING.name()),
        SCORE("score", "RELEVANCE", SortOrder.DESCENDING.name()),
        DISTANCE("distance", "DISTANCE", SortOrder.ASCENDING.name());

        private final String key;
        private final String attribute;
        private final String order;

        private SortMap(String sortKey, String sortAttribute, String sortOrder) {
            this.key = sortKey;
            this.attribute = sortAttribute;
            this.order = sortOrder;
        }

        public String getKey() {
            return this.key;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getOrder() {
            return this.order;
        }
    }
}

