/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.endpoint.date;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.di2e.ecdr.commons.util.ConfigAdminUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDateTypeConfigurations {
    private static final String MAPPING_PID = "cdr-endpoint-date-mapping";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDateTypeConfigurations.class);
    private static final Map<String, String> DATETYPE_MAP = new HashMap<String, String>();
    private ConfigurationAdmin configAdmin;

    public DefaultDateTypeConfigurations(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    public void init() throws IOException, InvalidSyntaxException {
        if (!ConfigAdminUtils.configurationPidExists((ConfigurationAdmin)this.configAdmin, (String)MAPPING_PID)) {
            for (Map.Entry<String, String> entry : DATETYPE_MAP.entrySet()) {
                LOGGER.debug("Adding configuration for date type with mapping {}={}", (Object)entry.getKey(), (Object)entry.getValue());
                Configuration configuration = this.configAdmin.createFactoryConfiguration(MAPPING_PID);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("cdrDateType", entry.getKey());
                ((Dictionary)properties).put("internalDateType", entry.getValue());
                configuration.update(properties);
            }
        }
    }

    static {
        DATETYPE_MAP.put("created", "created");
        DATETYPE_MAP.put("effective", "effective");
        DATETYPE_MAP.put("published", "effective");
        DATETYPE_MAP.put("updated", "modified");
    }
}

