/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.endpoint.sort;

import net.di2e.ecdr.api.config.SortTypeConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortTypeConfigurationImpl
implements SortTypeConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortTypeConfigurationImpl.class);
    private String sortKey;
    private String sortAttribute;
    private String customAttribute;
    private String sortOrder;

    public SortTypeConfigurationImpl() {
        LOGGER.info("Creating a new sort type configuration.");
    }

    public void setSortKey(String key) {
        LOGGER.debug("ConfigUpdate: Updating the SortKey to [{}] from [{}]", (Object)key, (Object)this.sortKey);
        this.sortKey = key;
    }

    public void setSortAttribute(String attribute) {
        if (StringUtils.isNotBlank((String)attribute)) {
            LOGGER.debug("ConfigUpdate: Updating the sortAttribute to [{}] from [{}]", (Object)attribute, (Object)this.sortAttribute);
            this.sortAttribute = attribute;
        } else {
            LOGGER.debug("ConfigUpdateError: Configuration update for SortAttribute in sortMapper for key=[{}] was empty or null so leaving at existing value for [{}]", (Object)this.sortKey, (Object)this.sortAttribute);
        }
    }

    public void setCustomSortAttribute(String attribute) {
        LOGGER.debug("ConfigUpdate: Updating the customSortAttribute to [{}] from [{}]", (Object)attribute, (Object)this.customAttribute);
        this.customAttribute = attribute;
    }

    public void setSortOrder(String order) {
        if (StringUtils.isNotBlank((String)order)) {
            LOGGER.debug("ConfigUpdate: Updating the SortOrder to [{}] from [{}]", (Object)order, (Object)this.sortOrder);
            this.sortOrder = order;
        } else {
            LOGGER.debug("ConfigUpdateError: Configuration update for SortOrder in sortMapper for key=[{}] was empty or null so leaving at existing value for [{}]", (Object)this.sortKey, (Object)this.sortOrder);
        }
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public String getSortAttribute() {
        if (StringUtils.isNotBlank((String)this.customAttribute)) {
            return this.customAttribute;
        }
        return this.sortAttribute;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }
}

