/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.endpoint.sort;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import net.di2e.ecdr.commons.util.ConfigAdminUtils;
import org.opengis.filter.sort.SortOrder;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSortTypeConfigurations {
    private static final String MAPPING_PID = "cdr-endpoint-sort-mapping";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSortTypeConfigurations.class);
    private ConfigurationAdmin configAdmin;

    public DefaultSortTypeConfigurations(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    public void init() throws IOException, InvalidSyntaxException {
        if (!ConfigAdminUtils.configurationPidExists((ConfigurationAdmin)this.configAdmin, (String)MAPPING_PID)) {
            for (SortMap map : SortMap.values()) {
                LOGGER.debug("Adding configuration with key {}", (Object)map.getKey());
                Configuration configuration = this.configAdmin.createFactoryConfiguration(MAPPING_PID);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("sortKey", map.getKey());
                ((Dictionary)properties).put("sortAttribute", map.getAttribute());
                ((Dictionary)properties).put("sortOrder", map.getOrder());
                configuration.update(properties);
            }
        }
    }

    public static enum SortMap {
        TITLE("*/title", "title", SortOrder.ASCENDING.name()),
        MODIFIED_DATE("*/updated", "modified", SortOrder.DESCENDING.name()),
        EFFECTIVE_DATE("*/published", "effective", SortOrder.DESCENDING.name()),
        CREATED_DATE("*/created", "created", SortOrder.DESCENDING.name()),
        SCORE("*/score", "RELEVANCE", SortOrder.DESCENDING.name()),
        DISTANCE("*/distance", "DISTANCE", SortOrder.ASCENDING.name());

        private final String key;
        private final String attribute;
        private final String order;

        private SortMap(String sortKey, String sortAttribute, String sortOrder) {
            this.key = sortKey;
            this.attribute = sortAttribute;
            this.order = sortOrder;
        }

        public String getKey() {
            return this.key;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getOrder() {
            return this.order;
        }
    }
}

