/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.interceptors;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Objects;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import net.devh.boot.grpc.server.security.check.GrpcSecurityMetadataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.core.AuthenticationException;

@GrpcGlobalServerInterceptor
public class AuthorizationCheckingServerInterceptor
extends AbstractSecurityInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationCheckingServerInterceptor.class);
    private final GrpcSecurityMetadataSource securityMetadataSource;

    public AuthorizationCheckingServerInterceptor(AccessDecisionManager accessDecisionManager, GrpcSecurityMetadataSource securityMetadataSource) {
        this.setAccessDecisionManager(Objects.requireNonNull(accessDecisionManager, "accessDecisionManager"));
        this.securityMetadataSource = Objects.requireNonNull(securityMetadataSource, "securityMetadataSource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCall.Listener result;
        InterceptorStatusToken token;
        MethodDescriptor methodDescriptor = call.getMethodDescriptor();
        try {
            token = this.beforeInvocation(methodDescriptor);
        }
        catch (AccessDeniedException | AuthenticationException e) {
            log.debug("Access denied");
            throw e;
        }
        log.debug("Access granted");
        try {
            result = next.startCall(call, headers);
        }
        finally {
            this.finallyInvocation(token);
        }
        return (ServerCall.Listener)this.afterInvocation(token, result);
    }

    public Class<?> getSecureObjectClass() {
        return MethodDescriptor.class;
    }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
    }
}

