/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.interceptors;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Objects;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import net.devh.boot.grpc.server.security.authentication.GrpcAuthenticationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@GrpcGlobalServerInterceptor
public class AuthenticatingServerInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatingServerInterceptor.class);
    private final AuthenticationManager authenticationManager;
    private final GrpcAuthenticationReader grpcAuthenticationReader;

    @Autowired
    public AuthenticatingServerInterceptor(AuthenticationManager authenticationManager, GrpcAuthenticationReader authenticationReader) {
        this.authenticationManager = Objects.requireNonNull(authenticationManager, "authenticationManager");
        this.grpcAuthenticationReader = authenticationReader;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Authentication authentication = this.grpcAuthenticationReader.readAuthentication(call, headers);
        if (authentication == null) {
            log.debug("No credentials found: Continuing unauthenticated");
            try {
                return next.startCall(call, headers);
            }
            catch (AccessDeniedException e) {
                throw new BadCredentialsException("No credentials found in the request", (Throwable)e);
            }
        }
        if (authentication.getDetails() == null && authentication instanceof AbstractAuthenticationToken) {
            ((AbstractAuthenticationToken)authentication).setDetails((Object)call.getAttributes());
        }
        log.debug("Credentials found: Authenticating...");
        authentication = this.authenticationManager.authenticate(authentication);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        log.debug("Authentication successful: Continuing as {} ({})", (Object)authentication.getName(), (Object)authentication.getAuthorities());
        try {
            AuthenticatingServerCallListener e = new AuthenticatingServerCallListener(next.startCall(call, headers), authentication);
            return e;
        }
        catch (AccessDeniedException e) {
            if (authentication instanceof AnonymousAuthenticationToken) {
                throw new BadCredentialsException("No credentials found in the request", (Throwable)e);
            }
            throw e;
        }
        finally {
            log.debug("startCall - Authentication cleared");
            SecurityContextHolder.clearContext();
        }
    }

    private class AuthenticatingServerCallListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        private final Authentication authentication;

        public AuthenticatingServerCallListener(ServerCall.Listener<ReqT> delegate, Authentication authentication) {
            super(delegate);
            this.authentication = authentication;
        }

        public void onMessage(ReqT message) {
            try {
                log.debug("onMessage - Authentication set");
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onMessage(message);
            }
            finally {
                log.debug("onMessage - Authentication cleared");
                SecurityContextHolder.clearContext();
            }
        }

        public void onHalfClose() {
            try {
                log.debug("onHalfClose - Authentication set");
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onHalfClose();
            }
            catch (AccessDeniedException e) {
                if (this.authentication instanceof AnonymousAuthenticationToken) {
                    throw new BadCredentialsException("No credentials found in the request", (Throwable)e);
                }
                throw e;
            }
            finally {
                log.debug("onHalfClose - Authentication cleared");
                SecurityContextHolder.clearContext();
            }
        }

        public void onCancel() {
            try {
                log.debug("onCancel - Authentication set");
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onCancel();
            }
            finally {
                log.debug("onCancel - Authentication cleared");
                SecurityContextHolder.clearContext();
            }
        }

        public void onComplete() {
            try {
                log.debug("onComplete - Authentication set");
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onComplete();
            }
            finally {
                log.debug("onComplete - Authentication cleared");
                SecurityContextHolder.clearContext();
            }
        }

        public void onReady() {
            try {
                log.debug("onReady - Authentication set");
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onReady();
            }
            finally {
                log.debug("onReady - Authentication cleared");
                SecurityContextHolder.clearContext();
            }
        }
    }
}

