/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.authentication;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import net.devh.boot.grpc.common.security.SecurityConstants;
import net.devh.boot.grpc.server.security.authentication.GrpcAuthenticationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class BearerAuthenticationReader
implements GrpcAuthenticationReader {
    private static final Logger log = LoggerFactory.getLogger(BearerAuthenticationReader.class);
    private static final String PREFIX = "Bearer ".toLowerCase();
    private static final int PREFIX_LENGTH = PREFIX.length();

    @Override
    public Authentication readAuthentication(ServerCall<?, ?> call, Metadata headers) {
        String header = (String)headers.get(SecurityConstants.AUTHORIZATION_HEADER);
        if (header == null || !header.toLowerCase().startsWith(PREFIX)) {
            log.debug("No bearer auth header found");
            return null;
        }
        String accessToken = header.substring(PREFIX_LENGTH);
        return new PreAuthenticatedAuthenticationToken((Object)accessToken, null);
    }
}

