/*
 * Copyright (c) 2016-2018 Michael Zhang <yidongnan@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package net.devh.boot.grpc.server.cloud;

import java.util.ArrayList;
import java.util.List;

import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistrationCustomizer;

import net.devh.boot.grpc.server.config.GrpcServerProperties;

/**
 * Adds the grpc server port to the consul registration.
 *
 * @author Michael (yidongnan@gmail.com)
 * @since 7/21/2018
 */
public class ConsulGrpcRegistrationCustomizer implements ConsulRegistrationCustomizer {

    private final GrpcServerProperties grpcServerProperties;

    /**
     * Creates a new ConsulGrpcRegistrationCustomizer which will read the grpc server port from the given
     * {@link GrpcServerProperties}.
     *
     * @param grpcServerProperties The properties to get the server port from.
     */
    public ConsulGrpcRegistrationCustomizer(final GrpcServerProperties grpcServerProperties) {
        this.grpcServerProperties = grpcServerProperties;
    }

    @Override
    public void customize(final ConsulRegistration registration) {
        List<String> tags = registration.getService().getTags();
        if (tags == null) {
            tags = new ArrayList<>();
        }
        tags.add("gRPC.port=" + this.grpcServerProperties.getPort());
        registration.getService().setTags(tags);
    }

}
