/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.security;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.devh.boot.grpc.client.inject.StubTransformer;
import net.devh.boot.grpc.common.security.SecurityConstants;

public class CallCredentialsHelper {
    public static StubTransformer fixedCredentialsStubTransformer(CallCredentials credentials) {
        Objects.requireNonNull(credentials, "credentials");
        return (name, stub) -> stub.withCallCredentials(credentials);
    }

    public static StubTransformer mappedCredentialsStubTransformer(Map<String, CallCredentials> credentialsByName) {
        return CallCredentialsHelper.mappedCredentialsStubTransformer(credentialsByName, null);
    }

    public static StubTransformer mappedCredentialsStubTransformer(Map<String, CallCredentials> credentialsByName, @Nullable CallCredentials fallback) {
        Objects.requireNonNull(credentialsByName, "credentials");
        return (name, stub) -> {
            CallCredentials credentials = credentialsByName.getOrDefault(name, fallback);
            if (credentials == null) {
                return stub;
            }
            return stub.withCallCredentials(credentials);
        };
    }

    public static CallCredentials bearerAuth(String token) {
        return CallCredentialsHelper.authorizationHeader("Bearer " + token);
    }

    public static CallCredentials bearerAuth(Supplier<String> tokenSource) {
        return CallCredentialsHelper.authorizationHeader(() -> "Bearer " + (String)tokenSource.get());
    }

    public static CallCredentials basicAuth(String username, String password) {
        return CallCredentialsHelper.authorizationHeader(CallCredentialsHelper.encodeBasicAuth(username, password));
    }

    public static String encodeBasicAuth(String username, String password) {
        byte[] encoded;
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(password, "password");
        String auth = username + ":" + password;
        try {
            encoded = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to encode basic authentication token", e);
        }
        return "Basic " + new String(encoded, StandardCharsets.UTF_8);
    }

    public static CallCredentials authorizationHeader(String authorization) {
        Objects.requireNonNull(authorization, "authorization");
        Metadata extraHeaders = new Metadata();
        extraHeaders.put(SecurityConstants.AUTHORIZATION_HEADER, (Object)authorization);
        return CallCredentialsHelper.authorizationHeaders(extraHeaders);
    }

    public static CallCredentials authorizationHeader(Supplier<String> authorizationSource) {
        Objects.requireNonNull(authorizationSource, "authorizationSource");
        return CallCredentialsHelper.authorizationHeaders(() -> {
            Metadata extraHeaders = new Metadata();
            extraHeaders.put(SecurityConstants.AUTHORIZATION_HEADER, (Object)((String)authorizationSource.get()));
            return extraHeaders;
        });
    }

    public static CallCredentials authorizationHeaders(Metadata authorizationHeaders) {
        return new StaticSecurityHeaderCallCredentials(authorizationHeaders);
    }

    public static CallCredentials authorizationHeaders(Supplier<Metadata> authorizationHeadersSupplier) {
        return new DynamicSecurityHeaderCallCredentials(authorizationHeadersSupplier);
    }

    public static boolean isPrivacyGuaranteed(SecurityLevel securityLevel) {
        return SecurityLevel.PRIVACY_AND_INTEGRITY == securityLevel;
    }

    public static CallCredentials requirePrivacy(CallCredentials callCredentials) {
        return new RequirePrivacyCallCredentials(callCredentials);
    }

    public static CallCredentials includeWhenPrivate(CallCredentials callCredentials) {
        return new IncludeWhenPrivateCallCredentials(callCredentials);
    }

    private CallCredentialsHelper() {
    }

    private static final class StaticSecurityHeaderCallCredentials
    extends CallCredentials {
        private final Metadata extraHeaders;

        StaticSecurityHeaderCallCredentials(Metadata authorizationHeaders) {
            this.extraHeaders = Objects.requireNonNull(authorizationHeaders, "authorizationHeaders");
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
            applier.apply(this.extraHeaders);
        }

        public void thisUsesUnstableApi() {
        }

        public String toString() {
            return "StaticSecurityHeaderCallCredentials [extraHeaders.keys=" + this.extraHeaders.keys() + "]";
        }
    }

    private static final class DynamicSecurityHeaderCallCredentials
    extends CallCredentials {
        private final Supplier<Metadata> extraHeadersSupplier;

        DynamicSecurityHeaderCallCredentials(Supplier<Metadata> authorizationHeadersSupplier) {
            this.extraHeadersSupplier = Objects.requireNonNull(authorizationHeadersSupplier, "authorizationHeadersSupplier");
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
            applier.apply(this.extraHeadersSupplier.get());
        }

        public void thisUsesUnstableApi() {
        }

        public String toString() {
            return "DynamicSecurityHeaderCallCredentials [extraHeadersSupplier=" + this.extraHeadersSupplier + "]";
        }
    }

    private static final class RequirePrivacyCallCredentials
    extends CallCredentials {
        private static final Status STATUS_LACKING_PRIVACY = Status.UNAUTHENTICATED.withDescription("Connection security level does not ensure credential privacy");
        private final CallCredentials callCredentials;

        RequirePrivacyCallCredentials(CallCredentials callCredentials) {
            this.callCredentials = callCredentials;
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
            if (CallCredentialsHelper.isPrivacyGuaranteed(requestInfo.getSecurityLevel())) {
                this.callCredentials.applyRequestMetadata(requestInfo, appExecutor, applier);
            } else {
                applier.fail(STATUS_LACKING_PRIVACY);
            }
        }

        public void thisUsesUnstableApi() {
        }

        public String toString() {
            return "RequirePrivacyCallCredentials [callCredentials=" + this.callCredentials + "]";
        }
    }

    private static final class IncludeWhenPrivateCallCredentials
    extends CallCredentials {
        private final CallCredentials callCredentials;

        IncludeWhenPrivateCallCredentials(CallCredentials callCredentials) {
            this.callCredentials = callCredentials;
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
            if (CallCredentialsHelper.isPrivacyGuaranteed(requestInfo.getSecurityLevel())) {
                this.callCredentials.applyRequestMetadata(requestInfo, appExecutor, applier);
            }
        }

        public void thisUsesUnstableApi() {
        }

        public String toString() {
            return "IncludeWhenPrivateCallCredentials [callCredentials=" + this.callCredentials + "]";
        }
    }
}

