/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.metrics;

import com.google.common.base.Stopwatch;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.function.Supplier;
import net.devh.boot.grpc.client.metrics.MetricsClientInstruments;
import net.devh.boot.grpc.client.metrics.MetricsClientMeters;
import net.devh.boot.grpc.client.metrics.MetricsClientStreamTracers;

public class MetricsClientInterceptor
implements ClientInterceptor {
    private final MetricsClientMeters metricsClientMeters;
    private final Supplier<Stopwatch> stopwatchSupplier;

    public MetricsClientInterceptor(MeterRegistry registry, Supplier<Stopwatch> stopwatchSupplier) {
        this(MetricsClientInstruments.newClientMetricsMeters(registry), stopwatchSupplier);
    }

    public MetricsClientInterceptor(MetricsClientMeters meters, Supplier<Stopwatch> stopwatchSupplier) {
        this.metricsClientMeters = meters;
        this.stopwatchSupplier = stopwatchSupplier;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final MetricsClientStreamTracers.CallAttemptsTracerFactory tracerFactory = new MetricsClientStreamTracers.CallAttemptsTracerFactory(new MetricsClientStreamTracers(this.stopwatchSupplier), method.getFullMethodName(), this.metricsClientMeters);
        ClientCall call = next.newCall(method, callOptions.withStreamTracerFactory((ClientStreamTracer.Factory)tracerFactory));
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                this.delegate().start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onClose(Status status, Metadata trailers) {
                        tracerFactory.callEnded(status);
                        super.onClose(status, trailers);
                    }
                }, headers);
            }
        };
    }
}

