/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.bocas.jersey;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.derquinse.bocas.BocasException;
import net.derquinse.common.base.ByteString;
import net.derquinse.common.base.NotInstantiable;

public final class BocasResources
extends NotInstantiable {
    public static final Splitter KEY_SPLITTER = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().omitEmptyStrings();
    public static final String KEY = "k";
    public static final String CATALOG = "catalog";
    public static final String HASH = "hash";

    private BocasResources() {
    }

    public static String checkKey(ByteString key) {
        return ((ByteString)Preconditions.checkNotNull((Object)key, (Object)"The object key must be provided")).toHexString();
    }

    public static String iterable2String(Iterable<ByteString> keys) {
        Preconditions.checkNotNull(keys, (Object)"The object keys must be provided");
        StringBuilder b = new StringBuilder();
        for (ByteString key : keys) {
            b.append(BocasResources.checkKey(key)).append('\n');
        }
        return b.toString();
    }

    public static List<ByteString> response2List(@Nullable String response) {
        if (response == null) {
            return ImmutableList.of();
        }
        try {
            LinkedList list = Lists.newLinkedList();
            for (String k : KEY_SPLITTER.split((CharSequence)response)) {
                list.add(ByteString.fromHexString((String)k));
            }
            return list;
        }
        catch (RuntimeException e) {
            throw new BocasException((Throwable)e);
        }
    }
}

