/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.bocas.jersey;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import net.derquinse.bocas.BocasException;
import net.derquinse.bocas.BocasValue;
import net.derquinse.common.base.ByteString;
import net.derquinse.common.base.NotInstantiable;
import net.derquinse.common.util.zip.MaybeCompressed;

public final class BocasResources
extends NotInstantiable {
    private static final Splitter KEY_SPLITTER = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().omitEmptyStrings();
    private static final Splitter ENTRY_SPLITTER = Splitter.on((char)':').trimResults().omitEmptyStrings();
    public static final String KEY = "k";
    public static final String CATALOG = "catalog";
    public static final String ZIP = "zip";
    public static final String ZIPGZIP = "zipgzip";

    private BocasResources() {
    }

    public static String checkKey(ByteString key) {
        return ((ByteString)Preconditions.checkNotNull((Object)key, (Object)"The object key must be provided")).toHexString();
    }

    public static String iterable2String(Iterable<ByteString> keys) {
        Preconditions.checkNotNull(keys, (Object)"The object keys must be provided");
        StringBuilder b = new StringBuilder();
        for (ByteString key : keys) {
            b.append(BocasResources.checkKey(key)).append('\n');
        }
        return b.toString();
    }

    public static List<ByteString> response2List(@Nullable String response) {
        if (response == null) {
            return ImmutableList.of();
        }
        try {
            LinkedList list = Lists.newLinkedList();
            for (String k : KEY_SPLITTER.split((CharSequence)response)) {
                list.add(ByteString.fromHexString((String)k));
            }
            return list;
        }
        catch (RuntimeException e) {
            throw new BocasException((Throwable)e);
        }
    }

    public static StreamingOutput value2Output(final BocasValue value) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                ByteStreams.copy((InputSupplier)value, (OutputStream)output);
            }
        };
    }

    public static String zip2response(Map<String, ByteString> entries) {
        if (entries == null || entries.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, ByteString> entry : entries.entrySet()) {
            b.append(entry.getValue().toHexString()).append(':').append(entry.getKey()).append('\n');
        }
        return b.toString();
    }

    public static String czip2response(Map<String, MaybeCompressed<ByteString>> entries) {
        if (entries == null || entries.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, MaybeCompressed<ByteString>> entry : entries.entrySet()) {
            b.append(((ByteString)entry.getValue().getPayload()).toHexString()).append(':').append(entry.getValue().isCompressed() ? "1" : "0").append(':').append(entry.getKey()).append('\n');
        }
        return b.toString();
    }

    public static Map<String, ByteString> response2zip(String response) {
        if (response == null) {
            return ImmutableMap.of();
        }
        HashMap map = Maps.newHashMap();
        for (String line : KEY_SPLITTER.split((CharSequence)response)) {
            LinkedList parts = Lists.newLinkedList((Iterable)ENTRY_SPLITTER.split((CharSequence)line));
            if (parts.size() != 2) continue;
            map.put(parts.get(1), ByteString.fromHexString((String)((String)parts.get(0))));
        }
        return map;
    }

    public static Map<String, MaybeCompressed<ByteString>> response2czip(String response) {
        if (response == null) {
            return ImmutableMap.of();
        }
        HashMap map = Maps.newHashMap();
        for (String line : KEY_SPLITTER.split((CharSequence)response)) {
            LinkedList parts = Lists.newLinkedList((Iterable)ENTRY_SPLITTER.split((CharSequence)line));
            if (parts.size() != 3) continue;
            ByteString key = ByteString.fromHexString((String)((String)parts.get(0)));
            boolean compressed = "1".equals(parts.get(1));
            map.put(parts.get(2), MaybeCompressed.of((boolean)compressed, (Object)key));
        }
        return map;
    }
}

