/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.bocas.gcs;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.derquinse.bocas.BocasException;
import net.derquinse.bocas.BocasHashFunction;
import net.derquinse.bocas.BocasPreconditions;
import net.derquinse.bocas.SimpleSkeletalBocas;
import net.derquinse.common.base.ByteString;
import net.derquinse.common.io.MemoryByteSource;
import net.derquinse.common.io.MemoryByteSourceLoader;
import net.derquinse.common.io.MemoryOutputStream;

@Beta
final class GCSBucket
extends SimpleSkeletalBocas {
    private final Storage storage;
    private final String bucket;
    private final MemoryByteSourceLoader loader;

    private static void checkKey(ByteString key) {
        Preconditions.checkNotNull((Object)key, (Object)"The object key must be provided");
    }

    private static Set<ByteString> checkKeys(Iterable<ByteString> keys) {
        Preconditions.checkNotNull(keys, (Object)"The object keys must be provided");
        HashSet set = Sets.newHashSet();
        for (ByteString key : keys) {
            Preconditions.checkNotNull((Object)key, (Object)"Null keys not allowed");
            set.add(key);
        }
        return set;
    }

    GCSBucket(Storage storage, String bucket, BocasHashFunction function, MemoryByteSourceLoader loader) {
        super(function);
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
        this.bucket = (String)Preconditions.checkNotNull((Object)bucket);
        this.loader = BocasPreconditions.checkLoader((MemoryByteSourceLoader)loader);
    }

    private Storage.Objects.Get getObjectRequest(ByteString key) {
        GCSBucket.checkKey(key);
        try {
            return this.storage.objects().get(this.bucket, key.toHexString());
        }
        catch (IOException e) {
            throw new BocasException((Throwable)e);
        }
    }

    public void close() {
    }

    public boolean contains(ByteString key) {
        GCSBucket.checkKey(key);
        Storage.Objects.Get request = this.getObjectRequest(key);
        try {
            StorageObject obj = (StorageObject)request.execute();
            return obj != null;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw new BocasException((Throwable)e);
        }
        catch (IOException e) {
            throw new BocasException((Throwable)e);
        }
    }

    public Set<ByteString> contained(Iterable<ByteString> keys) {
        Set<ByteString> input = GCSBucket.checkKeys(keys);
        HashSet set = Sets.newHashSet();
        for (ByteString key : input) {
            if (!this.contains(key)) continue;
            set.add(key);
        }
        return set;
    }

    public Optional<ByteSource> get(ByteString key) {
        GCSBucket.checkKey(key);
        Storage.Objects.Get request = this.getObjectRequest(key);
        MemoryOutputStream os = this.loader.openStream();
        try {
            request.executeMediaAndDownloadTo((OutputStream)os);
            Optional optional = Optional.of((Object)os.toByteSource());
            return optional;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                Optional optional = Optional.absent();
                return optional;
            }
            throw new BocasException((Throwable)e);
        }
        catch (IOException e) {
            throw new BocasException((Throwable)e);
        }
        finally {
            os.close();
        }
    }

    public Map<ByteString, ByteSource> get(Iterable<ByteString> keys) {
        Set<ByteString> input = GCSBucket.checkKeys(keys);
        HashMap map = Maps.newHashMap();
        for (ByteString key : input) {
            Optional<ByteSource> v;
            GCSBucket.checkKey(key);
            if (map.containsKey(key) || !(v = this.get(key)).isPresent()) continue;
            map.put(key, v.get());
        }
        return map;
    }

    protected void put(ByteString key, ByteSource value) {
        block8: {
            boolean ok = false;
            try {
                InputStream is = value.openStream();
                try {
                    InputStreamContent content = new InputStreamContent("application/octet-stream", is);
                    if (value instanceof MemoryByteSource) {
                        content.setLength(value.size());
                    }
                    Storage.Objects.Insert request = this.storage.objects().insert(this.bucket, null, (AbstractInputStreamContent)content);
                    request.setName(key.toHexString());
                    request.execute();
                    ok = true;
                }
                catch (IOException e) {
                    throw new BocasException((Throwable)e);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                if (ok) break block8;
                throw new BocasException((Throwable)e);
            }
        }
    }

    protected void putAll(Map<ByteString, ByteSource> entries) {
        for (Map.Entry<ByteString, ByteSource> entry : entries.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }
}

