/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.bocas.gcs;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import net.derquinse.bocas.Bocas;
import net.derquinse.bocas.BocasException;
import net.derquinse.bocas.BocasHashFunction;
import net.derquinse.bocas.BocasPreconditions;
import net.derquinse.bocas.BocasService;
import net.derquinse.bocas.gcs.GCSBucket;
import net.derquinse.common.io.MemoryByteSourceLoader;

final class GCSBocasService
implements BocasService {
    private static HttpTransport HTTP_TRANSPORT;
    private static JsonFactory JSON_FACTORY;
    private final Storage storage;
    private final BocasHashFunction function;
    private final MemoryByteSourceLoader loader;

    private static synchronized void init() {
        try {
            HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            JSON_FACTORY = JacksonFactory.getDefaultInstance();
        }
        catch (Exception e) {
            throw new BocasException((Throwable)e);
        }
    }

    GCSBocasService(String email, File p12, BocasHashFunction function, MemoryByteSourceLoader loader) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkNotNull((Object)p12);
        this.function = BocasPreconditions.checkHash((BocasHashFunction)function);
        this.loader = BocasPreconditions.checkLoader((MemoryByteSourceLoader)loader);
        Preconditions.checkArgument((boolean)p12.exists());
        GCSBocasService.init();
        try {
            GoogleCredential credential = new GoogleCredential.Builder().setTransport(HTTP_TRANSPORT).setJsonFactory(JSON_FACTORY).setServiceAccountId(email).setServiceAccountScopes((Collection)ImmutableSet.of((Object)"https://www.googleapis.com/auth/devstorage.read_write")).setServiceAccountPrivateKeyFromP12File(p12).build();
            this.storage = new Storage.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName("GCSBocasTest").build();
        }
        catch (Exception e) {
            throw new BocasException((Throwable)e);
        }
    }

    public Bocas getBucket(String name) {
        return new GCSBucket(this.storage, name, this.function, this.loader);
    }
}

