/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.bocas.gcs;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import net.derquinse.bocas.Bocas;
import net.derquinse.bocas.BocasException;
import net.derquinse.bocas.BocasHashFunction;
import net.derquinse.bocas.BocasPreconditions;
import net.derquinse.bocas.BocasService;
import net.derquinse.bocas.gcs.GCSBucket;
import net.derquinse.common.io.MemoryByteSourceLoader;

final class GCSBocasService
implements BocasService {
    private static final String GCS_URL = "http://storage.googleapis.com/";
    private static final String GCS_SCOPE = "https://www.googleapis.com/auth/devstorage.read_write";
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private final HttpRequestFactory factory;
    private final BocasHashFunction function;
    private final MemoryByteSourceLoader loader;

    GCSBocasService(String email, File p12, BocasHashFunction function, MemoryByteSourceLoader loader) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkNotNull((Object)p12);
        this.function = BocasPreconditions.checkHash((BocasHashFunction)function);
        this.loader = BocasPreconditions.checkLoader((MemoryByteSourceLoader)loader);
        Preconditions.checkArgument((boolean)p12.exists());
        try {
            GoogleCredential credential = new GoogleCredential.Builder().setTransport(HTTP_TRANSPORT).setJsonFactory(JSON_FACTORY).setServiceAccountId(email).setServiceAccountScopes(new String[]{GCS_SCOPE}).setServiceAccountPrivateKeyFromP12File(p12).build();
            this.factory = HTTP_TRANSPORT.createRequestFactory((HttpRequestInitializer)credential);
        }
        catch (Exception e) {
            throw new BocasException((Throwable)e);
        }
    }

    public Bocas getBucket(String name) {
        return new GCSBucket(this.factory, GCS_URL + name, this.function, this.loader);
    }
}

