/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.bocas.gcs;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.InputStreamContent;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.derquinse.bocas.BocasException;
import net.derquinse.bocas.BocasValue;
import net.derquinse.bocas.LoadedBocasValue;
import net.derquinse.bocas.SkeletalBocas;
import net.derquinse.common.base.ByteString;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Beta
final class GCSBucket
extends SkeletalBocas {
    private static final DateTimeFormatter RFC1123_DATE_FORMAT = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.UTC);
    private final HttpRequestFactory requestFactory;
    private final String bucketURI;

    private static void checkKey(ByteString key) {
        Preconditions.checkNotNull((Object)key, (Object)"The object key must be provided");
    }

    private static Set<ByteString> checkKeys(Iterable<ByteString> keys) {
        Preconditions.checkNotNull(keys, (Object)"The object keys must be provided");
        HashSet set = Sets.newHashSet();
        for (ByteString key : keys) {
            Preconditions.checkNotNull((Object)key, (Object)"Null keys not allowed");
            set.add(key);
        }
        return set;
    }

    GCSBucket(HttpRequestFactory requestFactory, String bucketURI) {
        this.requestFactory = (HttpRequestFactory)Preconditions.checkNotNull((Object)requestFactory);
        this.bucketURI = (String)Preconditions.checkNotNull((Object)bucketURI);
    }

    private GenericUrl getObjectURI(ByteString key) {
        return new GenericUrl(this.bucketURI + '/' + key.toHexString());
    }

    private HttpRequest decorate(HttpRequest request, Integer size) {
        HttpHeaders headers = request.getHeaders();
        headers.set("Host", (Object)"storage.googleapis.com");
        headers.setDate(RFC1123_DATE_FORMAT.print((ReadableInstant)DateTime.now()));
        headers.set("x-goog-api-version", (Object)"2");
        if (size != null) {
            headers.setContentLength(Long.valueOf(size.longValue()));
            headers.setContentType("application/octet-stream");
        }
        return request;
    }

    protected LoadedBocasValue load(BocasValue value) {
        return value.toLoaded();
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ByteString key) {
        boolean bl;
        GCSBucket.checkKey(key);
        HttpRequest request = this.decorate(this.requestFactory.buildHeadRequest(this.getObjectURI(key)), null);
        HttpResponse response = request.execute();
        try {
            bl = response.isSuccessStatusCode();
        }
        catch (Throwable throwable) {
            try {
                response.disconnect();
                throw throwable;
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 404) {
                    return false;
                }
                throw new BocasException((Throwable)e);
            }
            catch (IOException e) {
                throw new BocasException((Throwable)e);
            }
        }
        response.disconnect();
        return bl;
    }

    public Set<ByteString> contained(Iterable<ByteString> keys) {
        Set<ByteString> input = GCSBucket.checkKeys(keys);
        HashSet set = Sets.newHashSet();
        for (ByteString key : input) {
            if (!this.contains(key)) continue;
            set.add(key);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Optional<BocasValue> get(ByteString key) {
        GCSBucket.checkKey(key);
        try {
            HttpRequest request = this.decorate(this.requestFactory.buildGetRequest(this.getObjectURI(key)), null);
            HttpResponse response = request.execute();
            try {
                if (response.isSuccessStatusCode()) {
                    Optional optional;
                    InputStream is = response.getContent();
                    if (is == null) {
                        Optional optional2 = Optional.absent();
                        return optional2;
                    }
                    try {
                        optional = Optional.of((Object)BocasValue.heap((InputStream)is));
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly((Closeable)is);
                        throw throwable;
                    }
                    Closeables.closeQuietly((Closeable)is);
                    return optional;
                }
            }
            finally {
                response.disconnect();
            }
            return Optional.absent();
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return Optional.absent();
            }
            throw new BocasException((Throwable)e);
        }
        catch (IOException e) {
            throw new BocasException((Throwable)e);
        }
    }

    public Map<ByteString, BocasValue> get(Iterable<ByteString> keys) {
        Set<ByteString> input = GCSBucket.checkKeys(keys);
        HashMap map = Maps.newHashMap();
        for (ByteString key : input) {
            Optional<BocasValue> v;
            GCSBucket.checkKey(key);
            if (map.containsKey(key) || !(v = this.get(key)).isPresent()) continue;
            map.put(key, v.get());
        }
        return map;
    }

    protected void put(ByteString key, LoadedBocasValue value) {
        try {
            InputStreamContent content = new InputStreamContent("application/octet-stream", (InputStream)value.getInput());
            HttpRequest request = this.decorate(this.requestFactory.buildPutRequest(this.getObjectURI(key), (HttpContent)content), value.getSize());
            request.execute();
        }
        catch (IOException e) {
            throw new BocasException((Throwable)e);
        }
    }

    protected void putAll(Map<ByteString, LoadedBocasValue> entries) {
        for (Map.Entry<ByteString, LoadedBocasValue> entry : entries.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }
}

