/*
 * Decompiled with CFR 0.152.
 */
package net.dempsy.distconfig.clusterinfo;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import net.dempsy.cluster.ClusterInfoException;
import net.dempsy.cluster.ClusterInfoSession;
import net.dempsy.cluster.DirMode;
import net.dempsy.distconfig.PropertiesReader;
import net.dempsy.distconfig.PropertiesStore;
import net.dempsy.distconfig.clusterinfo.ClusterInfoPropertiesReader;
import net.dempsy.distconfig.clusterinfo.Utils;

public class ClusterInfoPropertiesStore
extends PropertiesStore {
    private final ClusterInfoSession session;
    private final String path;

    public ClusterInfoPropertiesStore(ClusterInfoSession session, String path) {
        this.session = session;
        this.path = Utils.cleanPath(path);
    }

    public int push(Properties props) {
        return this.write(props);
    }

    public int merge(Properties props) {
        PropertiesReader.VersionedProperties setProps = new ClusterInfoPropertiesReader(this.session, this.path).read(null);
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)setProps);
        newProps.putAll((Map<?, ?>)props);
        return this.write(newProps);
    }

    public int clear(String ... propNames) throws IOException {
        PropertiesReader.VersionedProperties setProps = new ClusterInfoPropertiesReader(this.session, this.path).read(null);
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)setProps);
        Arrays.stream(propNames).forEach(newProps::remove);
        return this.write(newProps);
    }

    private int write(Properties prop) {
        try {
            Utils.mkdir(this.session, this.path);
            String ret = this.session.mkdir(this.path + "/v_", (Object)prop, DirMode.PERSISTENT_SEQUENTIAL);
            this.session.setData(this.path, (Object)prop);
            return Integer.parseInt(ret.substring(ret.lastIndexOf("/v_") + Utils.versionSubdirPrefixLen, ret.length()));
        }
        catch (ClusterInfoException cie) {
            throw new RuntimeException(cie);
        }
    }
}

