/*
 * Decompiled with CFR 0.152.
 */
package net.dempsy.distconfig.clusterinfo;

import java.util.Collection;
import java.util.Properties;
import java.util.function.BinaryOperator;
import net.dempsy.cluster.ClusterInfoException;
import net.dempsy.cluster.ClusterInfoSession;
import net.dempsy.distconfig.PropertiesReader;
import net.dempsy.distconfig.PropertiesWatcher;
import net.dempsy.distconfig.clusterinfo.Utils;

public class ClusterInfoPropertiesReader
implements PropertiesReader {
    private final ClusterInfoSession session;
    private final String path;
    private final BinaryOperator<String> findLatest = (prev, cur) -> prev == null ? cur : (prev.compareTo((String)cur) > 0 ? prev : cur);

    public ClusterInfoPropertiesReader(ClusterInfoSession session, String path) {
        this.session = session;
        this.path = Utils.cleanPath(path);
    }

    public PropertiesReader.VersionedProperties read(PropertiesWatcher watcher) {
        try {
            if (!this.session.exists(this.path, null)) {
                if (watcher == null) {
                    return new PropertiesReader.VersionedProperties(-1, null);
                }
                Utils.mkdir(this.session, Utils.cleanPath(this.path));
                return this.read(watcher);
            }
            Collection subdirs = this.session.getSubdirs(this.path, watcher == null ? null : () -> watcher.propertiesChanged());
            String curDir = subdirs.stream().reduce(null, this.findLatest, this.findLatest);
            if (curDir == null) {
                return new PropertiesReader.VersionedProperties(-1, null);
            }
            int latestVersion = Integer.parseInt(curDir.substring(Utils.versionSubdirPrefixLen, curDir.length()));
            return new PropertiesReader.VersionedProperties(latestVersion, (Properties)this.session.getData(this.path + "/" + curDir, watcher == null ? null : () -> watcher.propertiesChanged()));
        }
        catch (ClusterInfoException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsNotification() {
        return true;
    }
}

