/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.okhttp3.internal.http2;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import nakadi.shadow.okhttp3.Headers;
import nakadi.shadow.okhttp3.OkHttpClient;
import nakadi.shadow.okhttp3.Protocol;
import nakadi.shadow.okhttp3.Request;
import nakadi.shadow.okhttp3.Response;
import nakadi.shadow.okhttp3.ResponseBody;
import nakadi.shadow.okhttp3.internal.Internal;
import nakadi.shadow.okhttp3.internal.Util;
import nakadi.shadow.okhttp3.internal.connection.StreamAllocation;
import nakadi.shadow.okhttp3.internal.http.HttpCodec;
import nakadi.shadow.okhttp3.internal.http.RealResponseBody;
import nakadi.shadow.okhttp3.internal.http.RequestLine;
import nakadi.shadow.okhttp3.internal.http.StatusLine;
import nakadi.shadow.okhttp3.internal.http2.ErrorCode;
import nakadi.shadow.okhttp3.internal.http2.Header;
import nakadi.shadow.okhttp3.internal.http2.Http2Connection;
import nakadi.shadow.okhttp3.internal.http2.Http2Stream;
import nakadi.shadow.okio.ByteString;
import nakadi.shadow.okio.ForwardingSource;
import nakadi.shadow.okio.Okio;
import nakadi.shadow.okio.Sink;
import nakadi.shadow.okio.Source;

public final class Http2Codec
implements HttpCodec {
    private static final ByteString CONNECTION = ByteString.encodeUtf8("connection");
    private static final ByteString HOST = ByteString.encodeUtf8("host");
    private static final ByteString KEEP_ALIVE = ByteString.encodeUtf8("keep-alive");
    private static final ByteString PROXY_CONNECTION = ByteString.encodeUtf8("proxy-connection");
    private static final ByteString TRANSFER_ENCODING = ByteString.encodeUtf8("transfer-encoding");
    private static final ByteString TE = ByteString.encodeUtf8("te");
    private static final ByteString ENCODING = ByteString.encodeUtf8("encoding");
    private static final ByteString UPGRADE = ByteString.encodeUtf8("upgrade");
    private static final List<ByteString> HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY);
    private static final List<ByteString> HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE);
    private final OkHttpClient client;
    final StreamAllocation streamAllocation;
    private final Http2Connection connection;
    private Http2Stream stream;

    public Http2Codec(OkHttpClient client, StreamAllocation streamAllocation, Http2Connection connection) {
        this.client = client;
        this.streamAllocation = streamAllocation;
        this.connection = connection;
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) {
        return this.stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request.body() != null;
        List<Header> requestHeaders = Http2Codec.http2HeadersList(request);
        this.stream = this.connection.newStream(requestHeaders, hasRequestBody);
        this.stream.readTimeout().timeout(this.client.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout(this.client.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void flushRequest() throws IOException {
        this.connection.flush();
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean expectContinue) throws IOException {
        List<Header> headers = this.stream.takeResponseHeaders();
        Response.Builder responseBuilder = Http2Codec.readHttp2HeadersList(headers);
        if (expectContinue && Internal.instance.code(responseBuilder) == 100) {
            return null;
        }
        return responseBuilder;
    }

    public static List<Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> result = new ArrayList<Header>(headers.size() + 4);
        result.add(new Header(Header.TARGET_METHOD, request.method()));
        result.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        String host = request.header("Host");
        if (host != null) {
            result.add(new Header(Header.TARGET_AUTHORITY, host));
        }
        result.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            ByteString name = ByteString.encodeUtf8(headers.name(i).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name)) continue;
            result.add(new Header(name, headers.value(i)));
        }
        return result;
    }

    public static Response.Builder readHttp2HeadersList(List<Header> headerBlock) throws IOException {
        StatusLine statusLine = null;
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headerBlock.size();
        for (int i = 0; i < size; ++i) {
            Header header = headerBlock.get(i);
            if (header == null) {
                if (statusLine == null || statusLine.code != 100) continue;
                statusLine = null;
                headersBuilder = new Headers.Builder();
                continue;
            }
            ByteString name = header.name;
            String value = header.value.utf8();
            if (name.equals(Header.RESPONSE_STATUS)) {
                statusLine = StatusLine.parse("HTTP/1.1 " + value);
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name)) continue;
            Internal.instance.addLenient(headersBuilder, name.utf8(), value);
        }
        if (statusLine == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        return new Response.Builder().protocol(Protocol.HTTP_2).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        StreamFinishingSource source = new StreamFinishingSource(this.stream.getSource());
        return new RealResponseBody(response.headers(), Okio.buffer(source));
    }

    @Override
    public void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    class StreamFinishingSource
    extends ForwardingSource {
        public StreamFinishingSource(Source delegate) {
            super(delegate);
        }

        @Override
        public void close() throws IOException {
            Http2Codec.this.streamAllocation.streamFinished(false, Http2Codec.this);
            super.close();
        }
    }
}

