/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.subscribers;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.ListCompositeDisposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.EndConsumerHelper;
import nakadi.shadow.org.reactivestreams.Subscription;

public abstract class ResourceSubscriber<T>
implements FlowableSubscriber<T>,
Disposable {
    private final AtomicReference<Subscription> s = new AtomicReference();
    private final ListCompositeDisposable resources = new ListCompositeDisposable();
    private final AtomicLong missedRequested = new AtomicLong();

    public final void add(Disposable resource) {
        ObjectHelper.requireNonNull(resource, "resource is null");
        this.resources.add(resource);
    }

    @Override
    public final void onSubscribe(Subscription s) {
        if (EndConsumerHelper.setOnce(this.s, s, this.getClass())) {
            long r = this.missedRequested.getAndSet(0L);
            if (r != 0L) {
                s.request(r);
            }
            this.onStart();
        }
    }

    protected void onStart() {
        this.request(Long.MAX_VALUE);
    }

    protected final void request(long n) {
        SubscriptionHelper.deferredRequest(this.s, this.missedRequested, n);
    }

    @Override
    public final void dispose() {
        if (SubscriptionHelper.cancel(this.s)) {
            this.resources.dispose();
        }
    }

    @Override
    public final boolean isDisposed() {
        return SubscriptionHelper.isCancelled(this.s.get());
    }
}

