/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.subscribers;

import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.EndConsumerHelper;
import nakadi.shadow.org.reactivestreams.Subscription;

public abstract class DisposableSubscriber<T>
implements FlowableSubscriber<T>,
Disposable {
    final AtomicReference<Subscription> s = new AtomicReference();

    @Override
    public final void onSubscribe(Subscription s) {
        if (EndConsumerHelper.setOnce(this.s, s, this.getClass())) {
            this.onStart();
        }
    }

    protected void onStart() {
        this.s.get().request(Long.MAX_VALUE);
    }

    protected final void request(long n) {
        this.s.get().request(n);
    }

    protected final void cancel() {
        this.dispose();
    }

    @Override
    public final boolean isDisposed() {
        return this.s.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public final void dispose() {
        SubscriptionHelper.cancel(this.s);
    }
}

