/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.subjects;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.annotations.CheckReturnValue;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.observers.DeferredScalarDisposable;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.io.reactivex.subjects.Subject;

public final class AsyncSubject<T>
extends Subject<T> {
    static final AsyncDisposable[] EMPTY = new AsyncDisposable[0];
    static final AsyncDisposable[] TERMINATED = new AsyncDisposable[0];
    final AtomicReference<AsyncDisposable<T>[]> subscribers = new AtomicReference<AsyncDisposable[]>(EMPTY);
    Throwable error;
    T value;

    @CheckReturnValue
    public static <T> AsyncSubject<T> create() {
        return new AsyncSubject<T>();
    }

    AsyncSubject() {
    }

    @Override
    public void onSubscribe(Disposable s) {
        if (this.subscribers.get() == TERMINATED) {
            s.dispose();
        }
    }

    @Override
    public void onNext(T t) {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        if (t == null) {
            this.nullOnNext();
            return;
        }
        this.value = t;
    }

    void nullOnNext() {
        this.value = null;
        NullPointerException ex = new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        this.error = ex;
        for (AsyncDisposable as : this.subscribers.getAndSet(TERMINATED)) {
            as.onError(ex);
        }
    }

    @Override
    public void onError(Throwable t) {
        if (t == null) {
            t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.value = null;
        this.error = t;
        for (AsyncDisposable as : this.subscribers.getAndSet(TERMINATED)) {
            as.onError(t);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        T v = this.value;
        AsyncDisposable[] array = this.subscribers.getAndSet(TERMINATED);
        if (v == null) {
            for (AsyncDisposable as : array) {
                as.onComplete();
            }
        } else {
            for (AsyncDisposable as : array) {
                as.complete(v);
            }
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    @Override
    public Throwable getThrowable() {
        return this.subscribers.get() == TERMINATED ? this.error : null;
    }

    @Override
    protected void subscribeActual(Observer<? super T> s) {
        AsyncDisposable<T> as = new AsyncDisposable<T>(s, this);
        s.onSubscribe(as);
        if (this.add(as)) {
            if (as.isDisposed()) {
                this.remove(as);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                s.onError(ex);
            } else {
                T v = this.value;
                if (v != null) {
                    as.complete(v);
                } else {
                    as.onComplete();
                }
            }
        }
    }

    boolean add(AsyncDisposable<T> ps) {
        AsyncDisposable[] b;
        AsyncDisposable<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new AsyncDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(AsyncDisposable<T> ps) {
        AsyncDisposable[] b;
        AsyncDisposable<T>[] a;
        do {
            int n;
            if ((n = (a = this.subscribers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new AsyncDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    public boolean hasValue() {
        return this.subscribers.get() == TERMINATED && this.value != null;
    }

    public T getValue() {
        return this.subscribers.get() == TERMINATED ? (T)this.value : null;
    }

    public Object[] getValues() {
        Object[] objectArray;
        T v = this.getValue();
        if (v != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = v;
        } else {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    public T[] getValues(T[] array) {
        T v = this.getValue();
        if (v == null) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        if (array.length == 0) {
            array = Arrays.copyOf(array, 1);
        }
        array[0] = v;
        if (array.length != 1) {
            array[1] = null;
        }
        return array;
    }

    static final class AsyncDisposable<T>
    extends DeferredScalarDisposable<T> {
        private static final long serialVersionUID = 5629876084736248016L;
        final AsyncSubject<T> parent;

        AsyncDisposable(Observer<? super T> actual, AsyncSubject<T> parent) {
            super(actual);
            this.parent = parent;
        }

        @Override
        public void dispose() {
            if (super.tryDispose()) {
                this.parent.remove(this);
            }
        }

        void onComplete() {
            if (!this.isDisposed()) {
                this.actual.onComplete();
            }
        }

        void onError(Throwable t) {
            if (this.isDisposed()) {
                RxJavaPlugins.onError(t);
            } else {
                this.actual.onError(t);
            }
        }
    }
}

