/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.schedulers;

import java.util.concurrent.TimeUnit;
import nakadi.shadow.io.reactivex.annotations.NonNull;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;

public final class Timed<T> {
    final T value;
    final long time;
    final TimeUnit unit;

    public Timed(@NonNull T value, long time, @NonNull TimeUnit unit) {
        this.value = value;
        this.time = time;
        this.unit = ObjectHelper.requireNonNull(unit, "unit is null");
    }

    @NonNull
    public T value() {
        return this.value;
    }

    @NonNull
    public TimeUnit unit() {
        return this.unit;
    }

    public long time() {
        return this.time;
    }

    public long time(@NonNull TimeUnit unit) {
        return unit.convert(this.time, this.unit);
    }

    public boolean equals(Object other) {
        if (other instanceof Timed) {
            Timed o = (Timed)other;
            return ObjectHelper.equals(this.value, o.value) && this.time == o.time && ObjectHelper.equals((Object)this.unit, (Object)o.unit);
        }
        return false;
    }

    public int hashCode() {
        int h = this.value != null ? this.value.hashCode() : 0;
        h = h * 31 + (int)(this.time >>> 31 ^ this.time);
        h = h * 31 + this.unit.hashCode();
        return h;
    }

    public String toString() {
        return "Timed[time=" + this.time + ", unit=" + (Object)((Object)this.unit) + ", value=" + this.value + "]";
    }
}

